﻿
#include "iap_deal.h"

static unsigned char bank0 APToBoot0             @ 0xFE;
static unsigned char bank0 APToBoot1             @ 0xFF;
static sbit bank0 flag_INT                       @ 0x80*8+0;

static unsigned char iap_data_count;
static unsigned char iap_frame_cs_calculate;
static unsigned char iap_jump_flag;

static void wdt_init(void)
{
    WDTIN = 0b11111111;
    WDTCON = 0b10000011;                //开启看门狗，超时时间为256ms
    CST_WDT = 0;
    asm("clrwdt");
}

static void timer0_init(void)
{
    TM0IF = 0;
    TM0IN = 249;                        //溢出时间设为1ms
    TM0IE = 1;                          //开启Timer0溢出中断
    TM0CON = 0b11000000;                //使能Timer0，时钟16分频，CPUCLK    
}

static void uart_init(void)
{
    UR0_CR1 = 0b00001000;               //使能UART_RX
    UR0_BRR1 = 0b00100011;              //MCK/8, 波特率设为19200
    UR0_BRR0 = 0xD0;
    UR0_ST = 0b00100000;                //引脚交换，3.1作RX
    UR0_INTF = 0;
    UR0_INTE = 0b00000100;              //使能接收非空中断
    UR0_RNIF = 0;
    UART0_EN = 1;
}

void iap_init(void)
{
    GIE = 0;
    CPUCLK_4M();

    wdt_init();      // IAP所需程序 ,看门狗初始化
    PT3CON_1 = 0;    // IAP所需程序 ,PT3.1设为数字口，做UART管脚
    uart_init();     // IAP所需程序 ,UART初始化

    PT1EN_5 = 1;     //    AP Demo应用PT1.5为输出口
    timer0_init();

    iap_data_count = 0;         // IAP所需程序 ,参数初始化
    iap_frame_cs_calculate = 0; // IAP所需程序 ,参数初始化
    iap_jump_flag = 0;          // IAP所需程序 ,参数初始化
    APToBoot0 = 0;              // IAP所需程序 ,参数初始化
    APToBoot1 = 0;             // IAP所需程序 ,参数初始化
    flag_INT = 1;  // IAP所需程序 ,参数初始化决定中断入口在BootLoader中还是在AP中，必须在AP初始化时置1

    GIE = 1;
}

void iap_signal_detect(unsigned char receive_data)
{
    switch(iap_data_count)
    {
        case 0:
            if(receive_data != 0x55)
            {
                return;
            }
            iap_frame_cs_calculate = 0;
        break;
        case 1:
            if(receive_data != 0x01)
            {
                iap_data_count = 0;
                return;
            }
        break;
        case 2:
            if(receive_data != 0x21)
            {
                iap_data_count = 0;
                return;
            }
        break;
        case 3:
        break;
        case 4:
            if(receive_data != iap_frame_cs_calculate)
            {
                iap_data_count = 0;
            }
            else
            {
                iap_jump_flag = 1;
            }
            return;
        break;
        default:
            iap_data_count = 0;
            return;
    }
    iap_data_count++;
    iap_frame_cs_calculate += receive_data;
}

void iap_reset_judge(void)
{
    if(iap_jump_flag)
    {
        GIE = 0;
        APToBoot0 = 0x55;
        APToBoot1 = 0xAA;
        while(1);
    }
}

/*<!----------------- IAP所需程序 -----------------*/
asm("org 0x1FF0");      //AP信息区
asm("dw 0x0005");       //AP版本号    //1FF0
asm("dw 0x0000");       //CHECKSUM    //1FF1
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留，用于合并hex时，此地址写0x5A00，用于升级文件时，此地址写0x00h
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
asm("dw 0x0000");       //保留
/*<!----------------- IAP所需程序 -----------------*/
