;==============================================
; CS8M320 Special Register Address Definition
; Date:2023-09-04
; Version: V1.0.0 
;==============================================

;Data Memory Organization 00h-08h
IND0              EQU              00H     ;{ [7:0] }
IND1              EQU              01H     ;{ [7:0] }
FSR0              EQU              02H     ;{ [7:0] }
FSR1              EQU              03H     ;{ [7:0] }
STATUS            EQU              04H     ;{ 0, 0, 0, PD, TO, DC, C, Z }
WORK              EQU              05H     ;{ [7:0] }
INTF              EQU              06H     ;{ BRKIF, TM2IF, CAPIF, TM0IF, SRADIF, 0, E1IF, E0IF }
INTE              EQU              07H     ;{ GIE, TM2IE, CAPIE, TM0IE, SRADIE, 0, E1IE, E0IE }
BSR               EQU              08H     ;{ IRP0, IRP1, 0, 0, 0, 0, 0, PAGE[0:0] }

;Peripheral special registers 09h-7Ch
RSTSR             EQU              09H     ;{ 0, 0, 0, 0, 0, EMCF, ILOPF, 0 }
EADRH             EQU              0AH     ;{ EADR[15:8] }
EADRL             EQU              0BH     ;{ EADR[7:0] }
EDATH             EQU              0CH     ;{ EDATH[7:0] }
WDTCON            EQU              0DH     ;{ WDTEN, 0, 0, 0, 0, WTS[2:0] }
WDTIN             EQU              0EH     ;{ WDTIN[7:0] }
TM0CON            EQU              0FH     ;{ T0EN, T0RATE[2:0], 0, T0RSTB, T0SEL[1:0] }
TM0IN             EQU              10H     ;{ TM0IN[7:0] }
TM0CNT            EQU              11H     ;{ TM0CNT[7:0] }
PAGECTL           EQU              14H     ;{ 0, 0, 0, 0, 0, 0, 0, PAGE2 }
TM2CAP            EQU              15H     ;{ CAPEN, CAPCCP[1:0], CNTCLR, CAPSEL[1:0], BRKEN, BRKPOL }
MCK               EQU              16H     ;{ 0, 0, CST_WDT, 0, 0, MODE_EN, 0, LVRES_EN }
TM2CON            EQU              17H     ;{ T2EN, T2RATE[2:0], T2CKS, T2RSTB, T2OUT, PWM2OUT }
TM2IN             EQU              18H     ;{ TM2IN[7:0] }
TM2CNT            EQU              19H     ;{ TM2CNT[7:0] }
TM2R              EQU              1AH     ;{ TM2R[7:0] }
TM3CON            EQU              1BH     ;{ T3EN, T3RATE[2:0], T3CKS, T3RSTB, R_BEEP_CON, PWM_CON }
TM3IN             EQU              1CH     ;{ TM3IN[7:0] }
TM3CNT            EQU              1DH     ;{ TM3CNT[7:0] }
TM3R1             EQU              1EH     ;{ TM3R1[7:0] }
TM3INH            EQU              1FH     ;{ 0, 0, 0, 0, TM3INH[11:8] }
PT1               EQU              20H     ;{ 0, 0, PT1[5:3], 0, 0, PT1[0:0] }
PT1EN             EQU              21H     ;{ 0, 0, PT1EN[5:3], 0, 0, PT1EN[0:0] }
PT1PU             EQU              22H     ;{ 0, 0, PT1PU[5:3], 0, 0, PT1PU[0:0] }
PT1CON            EQU              23H     ;{ 0, 0, PT1W[2:0], E1M, E0M[1:0] }
TM2INH            EQU              24H     ;{ 0, 0, 0, 0, TM2IN[11:8] }
TM2CNTH           EQU              25H     ;{ TM3CNT_DT1[2:0], 0, TM2CNT[11:8] }
TM2RH             EQU              26H     ;{ TM3CNT_DT2[2:0], 0, TM2R[11:8] }
TM3CNTH           EQU              27H     ;{ TM3CNT_DT3[2:0], 0, TM3CNT[11:8] }
PT3               EQU              28H     ;{ PT3VTH[1:1], PT3[6:0] }
PT3EN             EQU              29H     ;{ PT3VTH[2:2], PT3EN[6:0] }
PT3PU             EQU              2AH     ;{ PT3VTH[3:3], PT3PU[6:0] }
PT3CON            EQU              2BH     ;{ 0, PT3CON[6:0] }
TM3R3             EQU              2CH     ;{ TM3R3[7:0] }
TM3CON2           EQU              2DH     ;{ DT3CK[1:0], DT3CNT[2:0], DT3_EN, P3H1OEN, P3L1OEN }
CONFIG1           EQU              2EH     ;{ P3H1INV, P3L1INV, 0, PWM3STALL, PWM2STALL, PWM2PO, PWM3PO1, 0 }
CONFIG2           EQU              2FH     ;{ VTHSEL, PWM3MD, PWM3NUM, PWM3WV, 0, 0, PWM3PO3, PWM3PO2 }
PT5               EQU              30H     ;{ PT5[7:5], 0, PT5[3:0] }
PT5EN             EQU              31H     ;{ PT5EN[7:5], 0, PT5EN[3:0] }
PT5PU             EQU              32H     ;{ PT5PU[7:5], PT1PD[3:3], PT5PU[3:0] }
PT5CON            EQU              33H     ;{ PT5CON[7:5], 0, PT5CON[3:0] }
SRADCON0          EQU              34H     ;{ ADC2V_EN, SARVCMSEL, SRADACKS[1:0], 0, 0, SRADCKS[1:0] }
SRADCON1          EQU              35H     ;{ SRADEN, SRADS, OFTEN, CALIF, ENOV, OFFEX, VREFS[1:0] }
SRADCON2          EQU              36H     ;{ CHS[3:0], 0, 0, 0, SAR_DIFFEN }
SRADL             EQU              37H     ;{ SRAD[7:0] }
SRADH             EQU              38H     ;{ 0, 0, 0, 0, SRAD[11:8] }
SROFTL            EQU              39H     ;{ SROFT[7:0] }
SROFTH            EQU              3AH     ;{ 0, 0, 0, 0, SROFT[11:8] }
TM3R2             EQU              3BH     ;{ TM3R2[7:0] }
INTF2             EQU              3CH     ;{ 0, 0, LVRES_IF, TM3IF, 0, LVDIF, I2CIF, UR0IF }
INTE2             EQU              3DH     ;{ 0, 0, LVRES_IE, TM3IE, 0, LVDIE, 0, 0 }
INTCFG            EQU              40H     ;{ INTCFG[7:0] }
PT1CON1           EQU              41H     ;{ 0, 0, 0, 0, 0, 0, 0, PT1CON[0:0] }
PT5CON1           EQU              42H     ;{ PT5W[7:5], 0, 0, 0, 0, 0 }
TM3CON3           EQU              45H     ;{ P3H3INV, P3L3INV, P3H3OEN, P3L3OEN, P3H2INV, P3L2INV, P3H2OEN, P3L2OEN }
UR0_CR1           EQU              50H     ;{ TX9D, RX9D, TX9_EN, RX9_EN, RX_EN, TX_EN, UART0_SEL, UART0_EN }
UR0_BRR0          EQU              51H     ;{ BRR0[7:0] }
UR0_BRR1          EQU              52H     ;{ 0, UARTDIV[2:0], BRR1[3:0] }
UR0_TX_REG        EQU              53H     ;{ TX_REG[7:0] }
UR0_RX_REG        EQU              54H     ;{ RX_REG[7:0] }
UR0_ST            EQU              55H     ;{ UR_TINV, UR_RINV, UR_SWAP, TXFIFO_EMPTY, RX_BUSY, TX_BUSY, RX_OV_ERR, STOP_ERR }
UR0_INTF          EQU              56H     ;{ 0, 0, 0, UR0ERRIF, UR0_RHIF, UR0_RNIF, UR0WK_IF, UR0_TEIF }
UR0_INTE          EQU              57H     ;{ 0, 0, 0, UR0ERRIE, UR0_RHIE, UR0_RNIE, UR0WK_IE, UR0_TEIE }
I2CCON            EQU              59H     ;{ I2C_EN, AWK_EN, CST_EN, ACK_EN, I2CSTUS[3:0] }
I2CCON1           EQU              5AH     ;{ I2C_SEL, 0, 0, 0, 0, 0, I2C_DIV[1:0] }
I2CDAT            EQU              5BH     ;{ I2CDAT[7:0] }
I2CADR            EQU              5CH     ;{ I2CADR[6:0], GC_EN }
I2C_INTF          EQU              5DH     ;{ I2C_TIF, I2C_RIF, I2C_STIF, 0, 0, 0, 0, 0 }
I2C_INTE          EQU              5EH     ;{ I2C_TIE, I2C_RIE, I2C_STIE, 0, 0, 0, 0, 0 }
ISPCON1           EQU              60H     ;{ 0, ISPWDTRF, 0, 0, 0, 0, 0, ISPOF }
WRPRT             EQU              63H     ;{ 0, 0, 0, 0, 0, 0, 0, WRPRTF }
TBLPEN            EQU              77H     ;{ TBLPEN[7:0] }
METCH             EQU              79H     ;{ 0, 0, 0, 0, METCH3, MCK1[1:0], METCH0 }
CONFLASH          EQU              7CH     ;{ 0, 0, CONFLASH[5:0] }

;-------------------------------------------------------
;  STATUS register bit map
;-------------------------------------------------------
Z                 EQU              0
C                 EQU              1
DC                EQU              2
TO                EQU              3
PD                EQU              4

;-------------------------------------------------------
;  INTF register bit map
;-------------------------------------------------------
E0IF              EQU              0
E1IF              EQU              1
SRADIF            EQU              3
TM0IF             EQU              4
CAPIF             EQU              5
TM2IF             EQU              6
BRKIF             EQU              7

;-------------------------------------------------------
;  INTE register bit map
;-------------------------------------------------------
E0IE              EQU              0
E1IE              EQU              1
SRADIE            EQU              3
TM0IE             EQU              4
CAPIE             EQU              5
TM2IE             EQU              6
GIE               EQU              7

;-------------------------------------------------------
;  BSR register bit map
;-------------------------------------------------------
PAGE_0            EQU              0
IRP1              EQU              6
IRP0              EQU              7

;-------------------------------------------------------
;  RSTSR register bit map
;-------------------------------------------------------
ILOPF             EQU              1
EMCF              EQU              2

;-------------------------------------------------------
;  EADRH register bit map
;-------------------------------------------------------
EADR_8            EQU              0
EADR_9            EQU              1
EADR_10           EQU              2
EADR_11           EQU              3
EADR_12           EQU              4
EADR_13           EQU              5
EADR_14           EQU              6
EADR_15           EQU              7

;-------------------------------------------------------
;  EADRL register bit map
;-------------------------------------------------------
EADR_0            EQU              0
EADR_1            EQU              1
EADR_2            EQU              2
EADR_3            EQU              3
EADR_4            EQU              4
EADR_5            EQU              5
EADR_6            EQU              6
EADR_7            EQU              7

;-------------------------------------------------------
;  EDATH register bit map
;-------------------------------------------------------
EDATH_0           EQU              0
EDATH_1           EQU              1
EDATH_2           EQU              2
EDATH_3           EQU              3
EDATH_4           EQU              4
EDATH_5           EQU              5
EDATH_6           EQU              6
EDATH_7           EQU              7

;-------------------------------------------------------
;  WDTCON register bit map
;-------------------------------------------------------
WTS_0             EQU              0
WTS_1             EQU              1
WTS_2             EQU              2
WDTEN             EQU              7

;-------------------------------------------------------
;  WDTIN register bit map
;-------------------------------------------------------
WDTIN_0           EQU              0
WDTIN_1           EQU              1
WDTIN_2           EQU              2
WDTIN_3           EQU              3
WDTIN_4           EQU              4
WDTIN_5           EQU              5
WDTIN_6           EQU              6
WDTIN_7           EQU              7

;-------------------------------------------------------
;  TM0CON register bit map
;-------------------------------------------------------
T0SEL_0           EQU              0
T0SEL_1           EQU              1
T0RSTB            EQU              2
T0RATE_0          EQU              4
T0RATE_1          EQU              5
T0RATE_2          EQU              6
T0EN              EQU              7

;-------------------------------------------------------
;  TM0IN register bit map
;-------------------------------------------------------
TM0IN_0           EQU              0
TM0IN_1           EQU              1
TM0IN_2           EQU              2
TM0IN_3           EQU              3
TM0IN_4           EQU              4
TM0IN_5           EQU              5
TM0IN_6           EQU              6
TM0IN_7           EQU              7

;-------------------------------------------------------
;  TM0CNT register bit map
;-------------------------------------------------------
TM0CNT_0          EQU              0
TM0CNT_1          EQU              1
TM0CNT_2          EQU              2
TM0CNT_3          EQU              3
TM0CNT_4          EQU              4
TM0CNT_5          EQU              5
TM0CNT_6          EQU              6
TM0CNT_7          EQU              7

;-------------------------------------------------------
;  PAGECTL register bit map
;-------------------------------------------------------
PAGE2             EQU              0

;-------------------------------------------------------
;  TM2CAP register bit map
;-------------------------------------------------------
BRKPOL            EQU              0
BRKEN             EQU              1
CAPSEL_0          EQU              2
CAPSEL_1          EQU              3
CNTCLR            EQU              4
CAPCCP_0          EQU              5
CAPCCP_1          EQU              6
CAPEN             EQU              7

;-------------------------------------------------------
;  MCK register bit map
;-------------------------------------------------------
LVRES_EN          EQU              0
MODE_EN           EQU              2
CST_WDT           EQU              5

;-------------------------------------------------------
;  TM2CON register bit map
;-------------------------------------------------------
PWM2OUT           EQU              0
T2OUT             EQU              1
T2RSTB            EQU              2
T2CKS             EQU              3
T2RATE_0          EQU              4
T2RATE_1          EQU              5
T2RATE_2          EQU              6
T2EN              EQU              7

;-------------------------------------------------------
;  TM2IN register bit map
;-------------------------------------------------------
TM2IN_0           EQU              0
TM2IN_1           EQU              1
TM2IN_2           EQU              2
TM2IN_3           EQU              3
TM2IN_4           EQU              4
TM2IN_5           EQU              5
TM2IN_6           EQU              6
TM2IN_7           EQU              7

;-------------------------------------------------------
;  TM2CNT register bit map
;-------------------------------------------------------
TM2CNT_0          EQU              0
TM2CNT_1          EQU              1
TM2CNT_2          EQU              2
TM2CNT_3          EQU              3
TM2CNT_4          EQU              4
TM2CNT_5          EQU              5
TM2CNT_6          EQU              6
TM2CNT_7          EQU              7

;-------------------------------------------------------
;  TM2R register bit map
;-------------------------------------------------------
TM2R_0            EQU              0
TM2R_1            EQU              1
TM2R_2            EQU              2
TM2R_3            EQU              3
TM2R_4            EQU              4
TM2R_5            EQU              5
TM2R_6            EQU              6
TM2R_7            EQU              7

;-------------------------------------------------------
;  TM3CON register bit map
;-------------------------------------------------------
PWM_CON           EQU              0
R_BEEP_CON        EQU              1
T3RSTB            EQU              2
T3CKS             EQU              3
T3RATE_0          EQU              4
T3RATE_1          EQU              5
T3RATE_2          EQU              6
T3EN              EQU              7

;-------------------------------------------------------
;  TM3IN register bit map
;-------------------------------------------------------
TM3IN_0           EQU              0
TM3IN_1           EQU              1
TM3IN_2           EQU              2
TM3IN_3           EQU              3
TM3IN_4           EQU              4
TM3IN_5           EQU              5
TM3IN_6           EQU              6
TM3IN_7           EQU              7

;-------------------------------------------------------
;  TM3CNT register bit map
;-------------------------------------------------------
TM3CNT_0          EQU              0
TM3CNT_1          EQU              1
TM3CNT_2          EQU              2
TM3CNT_3          EQU              3
TM3CNT_4          EQU              4
TM3CNT_5          EQU              5
TM3CNT_6          EQU              6
TM3CNT_7          EQU              7

;-------------------------------------------------------
;  TM3R1 register bit map
;-------------------------------------------------------
TM3R1_0           EQU              0
TM3R1_1           EQU              1
TM3R1_2           EQU              2
TM3R1_3           EQU              3
TM3R1_4           EQU              4
TM3R1_5           EQU              5
TM3R1_6           EQU              6
TM3R1_7           EQU              7

;-------------------------------------------------------
;  TM3INH register bit map
;-------------------------------------------------------
TM3INH_8          EQU              0
TM3INH_9          EQU              1
TM3INH_10         EQU              2
TM3INH_11         EQU              3

;-------------------------------------------------------
;  PT1 register bit map
;-------------------------------------------------------
PT1_0             EQU              0
PT1_3             EQU              3
PT1_4             EQU              4
PT1_5             EQU              5

;-------------------------------------------------------
;  PT1EN register bit map
;-------------------------------------------------------
PT1EN_0           EQU              0
PT1EN_3           EQU              3
PT1EN_4           EQU              4
PT1EN_5           EQU              5

;-------------------------------------------------------
;  PT1PU register bit map
;-------------------------------------------------------
PT1PU_0           EQU              0
PT1PU_3           EQU              3
PT1PU_4           EQU              4
PT1PU_5           EQU              5

;-------------------------------------------------------
;  PT1CON register bit map
;-------------------------------------------------------
E0M_0             EQU              0
E0M_1             EQU              1
E1M               EQU              2
PT1W_0            EQU              3
PT1W_1            EQU              4
PT1W_2            EQU              5

;-------------------------------------------------------
;  TM2INH register bit map
;-------------------------------------------------------
TM2IN_8           EQU              0
TM2IN_9           EQU              1
TM2IN_10          EQU              2
TM2IN_11          EQU              3

;-------------------------------------------------------
;  TM2CNTH register bit map
;-------------------------------------------------------
TM2CNT_8          EQU              0
TM2CNT_9          EQU              1
TM2CNT_10         EQU              2
TM2CNT_11         EQU              3
TM3CNT_DT1_0        EQU              5
TM3CNT_DT1_1        EQU              6
TM3CNT_DT1_2        EQU              7

;-------------------------------------------------------
;  TM2RH register bit map
;-------------------------------------------------------
TM2R_8            EQU              0
TM2R_9            EQU              1
TM2R_10           EQU              2
TM2R_11           EQU              3
TM3CNT_DT2_0        EQU              5
TM3CNT_DT2_1        EQU              6
TM3CNT_DT2_2        EQU              7

;-------------------------------------------------------
;  TM3CNTH register bit map
;-------------------------------------------------------
TM3CNT_8          EQU              0
TM3CNT_9          EQU              1
TM3CNT_10         EQU              2
TM3CNT_11         EQU              3
TM3CNT_DT3_0        EQU              5
TM3CNT_DT3_1        EQU              6
TM3CNT_DT3_2        EQU              7

;-------------------------------------------------------
;  PT3 register bit map
;-------------------------------------------------------
PT3_0             EQU              0
PT3_1             EQU              1
PT3_2             EQU              2
PT3_3             EQU              3
PT3_4             EQU              4
PT3_5             EQU              5
PT3_6             EQU              6
PT3VTH_1          EQU              7

;-------------------------------------------------------
;  PT3EN register bit map
;-------------------------------------------------------
PT3EN_0           EQU              0
PT3EN_1           EQU              1
PT3EN_2           EQU              2
PT3EN_3           EQU              3
PT3EN_4           EQU              4
PT3EN_5           EQU              5
PT3EN_6           EQU              6
PT3VTH_2          EQU              7

;-------------------------------------------------------
;  PT3PU register bit map
;-------------------------------------------------------
PT3PU_0           EQU              0
PT3PU_1           EQU              1
PT3PU_2           EQU              2
PT3PU_3           EQU              3
PT3PU_4           EQU              4
PT3PU_5           EQU              5
PT3PU_6           EQU              6
PT3VTH_3          EQU              7

;-------------------------------------------------------
;  PT3CON register bit map
;-------------------------------------------------------
PT3CON_0          EQU              0
PT3CON_1          EQU              1
PT3CON_2          EQU              2
PT3CON_3          EQU              3
PT3CON_4          EQU              4
PT3CON_5          EQU              5
PT3CON_6          EQU              6

;-------------------------------------------------------
;  TM3R3 register bit map
;-------------------------------------------------------
TM3R3_0           EQU              0
TM3R3_1           EQU              1
TM3R3_2           EQU              2
TM3R3_3           EQU              3
TM3R3_4           EQU              4
TM3R3_5           EQU              5
TM3R3_6           EQU              6
TM3R3_7           EQU              7

;-------------------------------------------------------
;  TM3CON2 register bit map
;-------------------------------------------------------
P3L1OEN           EQU              0
P3H1OEN           EQU              1
DT3_EN            EQU              2
DT3CNT_0          EQU              3
DT3CNT_1          EQU              4
DT3CNT_2          EQU              5
DT3CK_0           EQU              6
DT3CK_1           EQU              7

;-------------------------------------------------------
;  CONFIG1 register bit map
;-------------------------------------------------------
PWM3PO1           EQU              1
PWM2PO            EQU              2
PWM2STALL         EQU              3
PWM3STALL         EQU              4
P3L1INV           EQU              6
P3H1INV           EQU              7

;-------------------------------------------------------
;  CONFIG2 register bit map
;-------------------------------------------------------
PWM3PO2           EQU              0
PWM3PO3           EQU              1
PWM3WV            EQU              4
PWM3NUM           EQU              5
PWM3MD            EQU              6
VTHSEL            EQU              7

;-------------------------------------------------------
;  PT5 register bit map
;-------------------------------------------------------
PT5_0             EQU              0
PT5_1             EQU              1
PT5_2             EQU              2
PT5_3             EQU              3
PT5_5             EQU              5
PT5_6             EQU              6
PT5_7             EQU              7

;-------------------------------------------------------
;  PT5EN register bit map
;-------------------------------------------------------
PT5EN_0           EQU              0
PT5EN_1           EQU              1
PT5EN_2           EQU              2
PT5EN_3           EQU              3
PT5EN_5           EQU              5
PT5EN_6           EQU              6
PT5EN_7           EQU              7

;-------------------------------------------------------
;  PT5PU register bit map
;-------------------------------------------------------
PT5PU_0           EQU              0
PT5PU_1           EQU              1
PT5PU_2           EQU              2
PT5PU_3           EQU              3
PT1PD_3           EQU              4
PT5PU_5           EQU              5
PT5PU_6           EQU              6
PT5PU_7           EQU              7

;-------------------------------------------------------
;  PT5CON register bit map
;-------------------------------------------------------
PT5CON_0          EQU              0
PT5CON_1          EQU              1
PT5CON_2          EQU              2
PT5CON_3          EQU              3
PT5CON_5          EQU              5
PT5CON_6          EQU              6
PT5CON_7          EQU              7

;-------------------------------------------------------
;  SRADCON0 register bit map
;-------------------------------------------------------
SRADCKS_0         EQU              0
SRADCKS_1         EQU              1
SRADACKS_0        EQU              4
SRADACKS_1        EQU              5
SARVCMSEL         EQU              6
ADC2V_EN          EQU              7

;-------------------------------------------------------
;  SRADCON1 register bit map
;-------------------------------------------------------
VREFS_0           EQU              0
VREFS_1           EQU              1
OFFEX             EQU              2
ENOV              EQU              3
CALIF             EQU              4
OFTEN             EQU              5
SRADS             EQU              6
SRADEN            EQU              7

;-------------------------------------------------------
;  SRADCON2 register bit map
;-------------------------------------------------------
SAR_DIFFEN        EQU              0
CHS_0             EQU              4
CHS_1             EQU              5
CHS_2             EQU              6
CHS_3             EQU              7

;-------------------------------------------------------
;  SRADL register bit map
;-------------------------------------------------------
SRAD_0            EQU              0
SRAD_1            EQU              1
SRAD_2            EQU              2
SRAD_3            EQU              3
SRAD_4            EQU              4
SRAD_5            EQU              5
SRAD_6            EQU              6
SRAD_7            EQU              7

;-------------------------------------------------------
;  SRADH register bit map
;-------------------------------------------------------
SRAD_8            EQU              0
SRAD_9            EQU              1
SRAD_10           EQU              2
SRAD_11           EQU              3

;-------------------------------------------------------
;  SROFTL register bit map
;-------------------------------------------------------
SROFT_0           EQU              0
SROFT_1           EQU              1
SROFT_2           EQU              2
SROFT_3           EQU              3
SROFT_4           EQU              4
SROFT_5           EQU              5
SROFT_6           EQU              6
SROFT_7           EQU              7

;-------------------------------------------------------
;  SROFTH register bit map
;-------------------------------------------------------
SROFT_8           EQU              0
SROFT_9           EQU              1
SROFT_10          EQU              2
SROFT_11          EQU              3

;-------------------------------------------------------
;  TM3R2 register bit map
;-------------------------------------------------------
TM3R2_0           EQU              0
TM3R2_1           EQU              1
TM3R2_2           EQU              2
TM3R2_3           EQU              3
TM3R2_4           EQU              4
TM3R2_5           EQU              5
TM3R2_6           EQU              6
TM3R2_7           EQU              7

;-------------------------------------------------------
;  INTF2 register bit map
;-------------------------------------------------------
UR0IF             EQU              0
I2CIF             EQU              1
LVDIF             EQU              2
TM3IF             EQU              4
LVRES_IF          EQU              5

;-------------------------------------------------------
;  INTE2 register bit map
;-------------------------------------------------------
LVDIE             EQU              2
TM3IE             EQU              4
LVRES_IE          EQU              5

;-------------------------------------------------------
;  INTCFG register bit map
;-------------------------------------------------------
INTCFG_0          EQU              0
INTCFG_1          EQU              1
INTCFG_2          EQU              2
INTCFG_3          EQU              3
INTCFG_4          EQU              4
INTCFG_5          EQU              5
INTCFG_6          EQU              6
INTCFG_7          EQU              7

;-------------------------------------------------------
;  PT1CON1 register bit map
;-------------------------------------------------------
PT1CON_0          EQU              0

;-------------------------------------------------------
;  PT5CON1 register bit map
;-------------------------------------------------------
PT5W_5            EQU              5
PT5W_6            EQU              6
PT5W_7            EQU              7

;-------------------------------------------------------
;  TM3CON3 register bit map
;-------------------------------------------------------
P3L2OEN           EQU              0
P3H2OEN           EQU              1
P3L2INV           EQU              2
P3H2INV           EQU              3
P3L3OEN           EQU              4
P3H3OEN           EQU              5
P3L3INV           EQU              6
P3H3INV           EQU              7

;-------------------------------------------------------
;  UR0_CR1 register bit map
;-------------------------------------------------------
UART0_EN          EQU              0
UART0_SEL         EQU              1
TX_EN             EQU              2
RX_EN             EQU              3
RX9_EN            EQU              4
TX9_EN            EQU              5
RX9D              EQU              6
TX9D              EQU              7

;-------------------------------------------------------
;  UR0_BRR0 register bit map
;-------------------------------------------------------
BRR0_0            EQU              0
BRR0_1            EQU              1
BRR0_2            EQU              2
BRR0_3            EQU              3
BRR0_4            EQU              4
BRR0_5            EQU              5
BRR0_6            EQU              6
BRR0_7            EQU              7

;-------------------------------------------------------
;  UR0_BRR1 register bit map
;-------------------------------------------------------
BRR1_0            EQU              0
BRR1_1            EQU              1
BRR1_2            EQU              2
BRR1_3            EQU              3
UARTDIV_0         EQU              4
UARTDIV_1         EQU              5
UARTDIV_2         EQU              6

;-------------------------------------------------------
;  UR0_TX_REG register bit map
;-------------------------------------------------------
TX_REG_0          EQU              0
TX_REG_1          EQU              1
TX_REG_2          EQU              2
TX_REG_3          EQU              3
TX_REG_4          EQU              4
TX_REG_5          EQU              5
TX_REG_6          EQU              6
TX_REG_7          EQU              7

;-------------------------------------------------------
;  UR0_RX_REG register bit map
;-------------------------------------------------------
RX_REG_0          EQU              0
RX_REG_1          EQU              1
RX_REG_2          EQU              2
RX_REG_3          EQU              3
RX_REG_4          EQU              4
RX_REG_5          EQU              5
RX_REG_6          EQU              6
RX_REG_7          EQU              7

;-------------------------------------------------------
;  UR0_ST register bit map
;-------------------------------------------------------
STOP_ERR          EQU              0
RX_OV_ERR         EQU              1
TX_BUSY           EQU              2
RX_BUSY           EQU              3
TXFIFO_EMPTY        EQU              4
UR_SWAP           EQU              5
UR_RINV           EQU              6
UR_TINV           EQU              7

;-------------------------------------------------------
;  UR0_INTF register bit map
;-------------------------------------------------------
UR0_TEIF          EQU              0
UR0WK_IF          EQU              1
UR0_RNIF          EQU              2
UR0_RHIF          EQU              3
UR0ERRIF          EQU              4

;-------------------------------------------------------
;  UR0_INTE register bit map
;-------------------------------------------------------
UR0_TEIE          EQU              0
UR0WK_IE          EQU              1
UR0_RNIE          EQU              2
UR0_RHIE          EQU              3
UR0ERRIE          EQU              4

;-------------------------------------------------------
;  I2CCON register bit map
;-------------------------------------------------------
I2CSTUS_0         EQU              0
I2CSTUS_1         EQU              1
I2CSTUS_2         EQU              2
I2CSTUS_3         EQU              3
ACK_EN            EQU              4
CST_EN            EQU              5
AWK_EN            EQU              6
I2C_EN            EQU              7

;-------------------------------------------------------
;  I2CCON1 register bit map
;-------------------------------------------------------
I2C_DIV_0         EQU              0
I2C_DIV_1         EQU              1
I2C_SEL           EQU              7

;-------------------------------------------------------
;  I2CDAT register bit map
;-------------------------------------------------------
I2CDAT_0          EQU              0
I2CDAT_1          EQU              1
I2CDAT_2          EQU              2
I2CDAT_3          EQU              3
I2CDAT_4          EQU              4
I2CDAT_5          EQU              5
I2CDAT_6          EQU              6
I2CDAT_7          EQU              7

;-------------------------------------------------------
;  I2CADR register bit map
;-------------------------------------------------------
GC_EN             EQU              0
I2CADR_0          EQU              1
I2CADR_1          EQU              2
I2CADR_2          EQU              3
I2CADR_3          EQU              4
I2CADR_4          EQU              5
I2CADR_5          EQU              6
I2CADR_6          EQU              7

;-------------------------------------------------------
;  I2C_INTF register bit map
;-------------------------------------------------------
I2C_STIF          EQU              5
I2C_RIF           EQU              6
I2C_TIF           EQU              7

;-------------------------------------------------------
;  I2C_INTE register bit map
;-------------------------------------------------------
I2C_STIE          EQU              5
I2C_RIE           EQU              6
I2C_TIE           EQU              7

;-------------------------------------------------------
;  ISPCON1 register bit map
;-------------------------------------------------------
ISPOF             EQU              0
ISPWDTRF          EQU              6

;-------------------------------------------------------
;  WRPRT register bit map
;-------------------------------------------------------
WRPRTF            EQU              0

;-------------------------------------------------------
;  TBLPEN register bit map
;-------------------------------------------------------
TBLPEN_0          EQU              0
TBLPEN_1          EQU              1
TBLPEN_2          EQU              2
TBLPEN_3          EQU              3
TBLPEN_4          EQU              4
TBLPEN_5          EQU              5
TBLPEN_6          EQU              6
TBLPEN_7          EQU              7

;-------------------------------------------------------
;  METCH register bit map
;-------------------------------------------------------
METCH0            EQU              0
MCK1_0            EQU              1
MCK1_1            EQU              2
METCH3            EQU              3

;-------------------------------------------------------
;  CONFLASH register bit map
;-------------------------------------------------------
CONFLASH_0        EQU              0
CONFLASH_1        EQU              1
CONFLASH_2        EQU              2
CONFLASH_3        EQU              3
CONFLASH_4        EQU              4
CONFLASH_5        EQU              5

