﻿include "CS8M320.inc"
include "constant_define.inc"

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom   ;
INT_FUNCTION:
    push                                ;将WORK和STATUS压栈处理
    movfw   BSR
    push                                ;将BSR压栈处理
    clrf    BSR
    btfss   R_System_Flag,B_Int_Flag    ;中断入口标志为0标志BOOT中断，为1表示用户中断
    goto    L_INT_Timer0
    pop
    movwf   BSR                         ;恢复保护的BSR
    pop
    goto    404h                        ;跳转至用户中断入口

;============================================
; Timer0中断处理函数
;============================================
L_INT_Timer0:
    btfss   INTF,TM0IF
    goto    L_INT_Uart0
    bcf     INTF,TM0IF
    bsf     R_Time_Flag,B_Time_1ms
    goto    L_INT_Exit


;============================================
; Uart0中断处理函数
;============================================
;L_INT_Uart0:
;   btfss   INTF2,UR0IF
;   goto    L_INT_Exit
;   btfsc   UR0_INTF,UR0_RNIF
;   goto    L_Uart0_Receive_Deal
;   btfsc   UR0_INTF,UR0_TEIF
;   goto    L_Uart0_Send_Deal
;   btfsc   UR0_INTF,UR0ERRIF
;   goto    L_Uart0_Error_Deal
;   goto    L_INT_Exit
L_INT_Uart0:                            ;针对CC口5.1k下拉的额外处理
    btfss   INTF2,UR0IF
    goto    L_INT_Exit
    btfsc   UR0_INTF,UR0_RNIF
    goto    L_INT_Rec
    btfsc   UR0_INTF,UR0_TEIF
    goto    L_INT_Send
    goto    L_INT_Exit

L_INT_Rec:
    btfss   UR0_INTF,UR0ERRIF
    goto    L_Uart0_Receive_Deal
    incf    R_ERR_Count,1
    movlw   0Ah
    subwf   R_ERR_Count,0
    btfss   STATUS,C
    goto    L_INT_Exit
    clrf    R_ERR_Count
    clrf    UR0_INTE
    goto    L_INT_Exit
    
L_INT_Send:
    btfsc   UR0_INTE,UR0_TEIE
    goto    L_Uart0_Send_Deal
    goto    L_INT_Exit

;============================================
; Uart0接收中断处理函数
;============================================
L_Uart0_Receive_Deal:
    movfw   UR0_RX_REG
    movwf   R_RecData_Temp              ;读取UART接收数据
    bsf     R_Time_Flag,B_Comm_Start
    bsf     BSR,IRP1                    ;IND1间接寻址Page0后256字节

    movfw   R_RecData_Count
    movwf   FSR1                        ;确认数据存放位置
    movfw   R_RecData_Temp
    movwf   IND1                        ;保存UART接收数据
    
    movfw   R_RecHead
    xorlw   55h                         ;判断帧头是否正确
    btfsc   STATUS,Z
    goto    L_Receive_Length_Deal
    movlw   REPLY_CMD_HEAD_ERROR
    movwf   R_SendACK
    goto    L_Receive_Abnormal          ;帧头错误则直接进行回复
    
L_Receive_Length_Deal:  
    movfw   R_RecData_Count             ;判断是否为帧长度位
    xorlw   01h
    btfss   STATUS,Z
    goto    L_Receive_CS_Judge          ;不是帧长度位则进行校验
    movfw   R_RecLength         
    xorlw   00h
    btfss   STATUS,Z
    goto    L_MaxLength_Judge           ;帧长度不为零则判断长度上限
    movlw   REPLY_CMD_LENGTH_ZERO
    movwf   R_SendACK
    goto    L_Receive_Abnormal          ;帧长度为零则直接进行回复

L_MaxLength_Judge:
    movfw   R_RecLength
    sublw   45h
    btfsc   STATUS,C
    goto    L_CSPosition_Get            ;帧长度符合协议要求则获取帧校验位
    movlw   REPLY_CMD_LENGTH_BEYOUND
    movwf   R_SendACK
    goto    L_Receive_Abnormal          ;帧长度超限则直接进行回复
    
L_CSPosition_Get:
    movfw   R_RecLength
    movwf   R_FrameCS_Position
    movlw   03h
    addwf   R_FrameCS_Position,1        ;获取帧校验位位置
    movlw   55h
    movwf   R_FrameCS_Calculate         ;在帧校验位确认后，为帧计算赋初值

L_Receive_CS_Judge:
    movfw   R_RecData_Count             ;判断是否已经接收过命令码
    sublw   03h
    btfsc   STATUS,C
    goto    L_Receive_CS_Calculate      ;未收到过命令码则只计算，不比对帧校验码
    movfw   R_RecData_Count
    xorwf   R_FrameCS_Position,0        ;判断是否收到帧校验码
    btfsc   STATUS,Z
    goto    L_Receive_CSCheck           ;接收到帧校验码则进行比对   

L_Receive_CS_Calculate:
    movfw   R_RecData_Temp
    addwf   R_FrameCS_Calculate,1
    incf    R_RecData_Count,1
    goto    L_Receive_End

L_Receive_CSCheck:
    movfw   R_RecData_Temp              ;接收到帧校验码则进行校验
    xorwf   R_FrameCS_Calculate,0
    btfsc   STATUS,Z
    goto    L_Receive_CSCheck_OK
    movlw   REPLY_CMD_CHECK_ERROR       ;校验失败则直接回复
    movwf   R_SendACK
    goto    L_Receive_Abnormal

L_Receive_CSCheck_OK:
    movlw   REPLY_CMD_ACK
    movwf   R_SendACK
    bsf     R_System_Flag,B_RecData_OK  ;校验成功则进入执行阶段
    goto    L_Receive_End

L_Receive_Abnormal:
    bsf     R_System_Flag,B_RecData_OK      ;帧异常则认为接收完成并直接进行回复
    bsf     R_System_Flag,B_Comm_Abnormal   ;置位后等待15ms才允许再次接收数据

L_Receive_End:
    btfss   R_System_Flag,B_RecData_OK
    goto    L_INT_Exit
    clrf    BSR
    bcf     UR0_CR1,RX_EN                   ;接收完一帧数据后停止接收
    clrf    R_RecData_Count
    goto    L_INT_Exit


;============================================
; Uart0发送中断处理函数
;============================================
L_Uart0_Send_Deal:
    bcf     UR0_INTF,UR0_TEIF
    bsf     BSR,IRP1                    ;IND1间接寻址Page0后256字节
    incf    R_SendData_Count,1
    movfw   R_FrameCS_Position
    subwf   R_SendData_Count,0
    btfsc   STATUS,C                    ;判断是否发送帧校验码
    goto    L_Send_CS
    movfw   R_SendData_Count
    addlw   80h                         ;发送数据缓存起始地址为180h
    movwf   FSR1
    movfw   IND1
    movwf   R_SendData_Temp             ;依次准备发送数据
    addwf   R_FrameCS_Calculate,1       ;计算帧校验码
    movfw   R_SendData_Temp
    movwf   UR0_TX_REG                  ;发送数据
    goto    L_INT_Exit

    
L_Send_CS:
    movfw   R_FrameCS_Calculate
    movwf   UR0_TX_REG                  ;准备发送帧校验码
    nop
    nop
    nop
    bcf     UR0_INTE,UR0_TEIE
    btfsc   UR0_ST,TX_BUSY
    goto    $-1
    clrf    UR0_CR1
    bsf     UR0_ST,UR_SWAP
    movlw   0b00001001
    movwf   UR0_CR1
    goto    L_INT_Exit
        

;============================================
; Uart0错误中断处理函数
;============================================
L_Uart0_Error_Deal:
    bcf     UR0_ST,RX_OV_ERR
    bcf     UR0_ST,STOP_ERR
    bcf     UR0_CR1,RX_EN               ;停止接收
    movlw   REPLY_CMD_UNKNOWN_ERROR     ;发送接收错误则直接回复发生了未知错误
    movwf   R_SendACK
    bsf     R_System_Flag,B_RecData_OK  ;认为接收完成并直接进行回复
    clrf    R_RecData_Count
    goto    L_INT_Exit

L_INT_Exit:
    pop                                 ; 把BSR寄存器出栈处理
    movwf   BSR
    pop                                 ; 把WORK和STATUS寄存器出栈处理
    retfie                              ; 从中断返回

.ends