﻿include "CS8M320.inc"
include "constant_define.inc"

;===========================================================
; ISP读操作
;===========================================================
F_ISP_Read:
    bcf     INTE,GIE                            ;关总中断
    movfw   R_ROM_AddrL
    movwf   EADRL                               ;赋读地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                               ;赋读地址高位
    movp
    nop
    movwf   R_ROM_DataL                         ;读数据低位
    movfw   EDATH
    movwf   R_ROM_DataH                         ;读数据高位
    bsf     INTE,GIE                            ;开总中断
    return


;===========================================================
; ISP写操作
;===========================================================
/*操作步骤：关中断>清page latch>页擦除>清page latch>写page latch>页烧录>开中断*/
F_ISP_Write:
    bcf     INTE,GIE                            ;关总中断
    movlw   0b01011010
    movwf   TBLPEN                              ;使能TBLP操作
    
L_ISP_Write:
    movlw   0E0h                                ;判断是否写最后一页
    subwf   R_ROM_AddrL,0
    movlw   1Fh
    subwfc  R_ROM_AddrH,0
    btfss   STATUS,C
    goto    L_WriteROM
    clrf    R_ROM_AddrL                         ;写最后一页时先将数据缓存至Row0区域    
    movlw   20h
    movwf   R_ROM_AddrH

L_WriteROM:
    call    F_Clear_PageLatch                   ;清除page latch
    movfw   R_ROM_AddrL
    movwf   EADRL                               ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                               ;赋写地址高位
    call    F_Page_Erase                        ;页擦除
    call    F_Clear_PageLatch                   ;清除page latch
    
    call    F_Write_Page_Latch                  ;将需要写入ROM的数据先写入page latch内
    
    movfw   R_ROM_AddrL
    movwf   EADRL                               ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                               ;赋写地址高位
    call    F_Page_Write                        ;页烧录
    
    btfsc   ISPCON1,ISPOF                       ;判断校验是否正确
    goto    L_WriteROM_Repeat                   ;校验失败则重复写ROM
    bsf     R_System_Flag,B_Execute_OK
    goto    L_ISP_Write_End

L_WriteROM_Repeat:  
    bcf     ISPCON1,ISPOF
    incf    R_ROM_WCount_Try,1                  ;若不正确，则重复写最多3次
    movlw   3
    subwf   R_ROM_WCount_Try,0
    btfss   STATUS,C
    goto    L_ISP_Write
    bcf     R_System_Flag,B_Execute_OK          ;3次写入均校验失败，则回复无法写入ROM数据
    
L_ISP_Write_End:
    clrf    R_ROM_WCount_Try
    clrf    TBLPEN                              ;关闭TBLP使能
    bsf     INTE,GIE                            ;开总中断
    return

;===========================================================
; Page Latch写操作
;===========================================================
F_Write_Page_Latch:
    movlw   0b10000000
    movwf   BSR
    movfw   R_ROM_AddrL
    movwf   EADRL                   ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                   ;赋写地址高位
    movlw   07h
    movwf   FSR0                    ;写入数据缓存在07h为首地址的RAM空间里
    
L_Write_Page_Latch_Loop:    
    movfw   IND0    
    movwf   EDATH                   ;准备数据高位
    incf    FSR0,1
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT                   ;解锁TBLP操作
    movfw   IND0                    ;准备数据低位
    tblp    69h                     ;写入数据
    nop
    
    incf    R_Page_Latch_Count,1    ;记录写入次数
    movlw   32
    subwf   R_Page_Latch_Count,0
    btfsc   STATUS,C
    goto    L_Write_Page_Latch_End  ;写完32次后，退出写page latch
    incf    EADRL,1
    incf    FSR0,1
    goto    L_Write_Page_Latch_Loop ;否则再次准备数据，写page latch
    
L_Write_Page_Latch_End:
    clrf    R_Page_Latch_Count      ;退出写page latch时，清写入次数，清BSR
    clrf    BSR
    return
    
;===========================================================
;ROM页擦除操作
;===========================================================
;F_ISP_Sector_Erase:
;   call    F_ISP_Idle_Wait                     ;等待前序操作结束
;   btfsc   R_ISP_Flag,B_ISP_Busy
;   goto    L_ISP_Sector_Erase_Fail
;   movlw   ISP_CMD_ERASE_SECTOR
;   movwf   CMD                                 ;ISP选择页擦除
;   
;   bcf     GIE                                 ;关总中断
;   bsf     ISPEN                               ;使能ISP擦写操作
;   movfw   R_ROM_AddrL
;   movwf   EADRL                               ;赋擦地址低位
;   movfw   R_ROM_AddrH
;   movwf   EADRH                               ;赋擦地址高位
;;  movlw   AP_START_ADDRH
;;  subwf   EADRH,0                             ;不允许擦除BootLoader区域
;;  btfss   C
;;  goto    L_ISP_Sector_Erase_Fail
;   movlw   96h
;   movwf   WRPRT
;   movlw   69h
;   movwf   WRPRT
;   movlw   5Ah
;   movwf   WRPRT
;   btfss   UNLOCK                              ;判断解锁是否成功
;   goto    L_ISP_Sector_Erase_Fail
;   bsf     START                               ;擦除数据
;   
;   btfsc   ISPOF                               ;判断是否擦除成功
;   goto    L_ISP_Sector_Erase_Fail
;   bsf     R_System_Flag,B_Execute_OK
;   goto    L_ISP_Sector_Erase_End
;   
;L_ISP_Sector_Erase_Fail:
;   bcf     R_System_Flag,B_Execute_OK
;
;L_ISP_Sector_Erase_End:
;   clrf    WRPRT
;   clrf    ISPSR
;   bsf     GIE                                 ;开总中断
;   return
    
    
;===========================================================
;AP ROM擦除操作
;===========================================================
F_ISP_APROM_Erase:
    bcf     INTE,GIE                        ;关总中断
    movlw   0b01011010
    movwf   TBLPEN                          ;使能TBLP操作

    movlw   AP_START_ADDRL
    movwf   EADRL                           ;赋地址低位，从前向后依次擦除
    movlw   AP_START_ADDRH
    movwf   EADRH

L_Clear_ROM_Loop:   
    movfw   R_User_Data_StartL
    xorwf   EADRL,0
    btfsc   STATUS,Z                        ;低位相等时，异或结果为0，Z = 1，执行下一条指令跳转判断高位;不等时，跳转擦除
    goto    L_Addr_Judge
    
L_Clear_Page:
    call    F_Clear_PageLatch               ;清除page latch
    call    F_Page_Erase                    ;页擦除
    call    F_Clear_PageLatch               ;清除page latch
    movlw   20h
    addwf   EADRL,1                         ;每页之间地址相差20h
    btfss   STATUS,C                        ;若发生进位，C = 1，跳过下一条指令    
    goto    L_Clear_ROM_Loop    
    incf    EADRH,1                         ;地址高位加1           //////////第一次就跳过来了
    goto    L_Clear_ROM_Loop

L_Addr_Judge:
    movfw   R_User_Data_StartH
    xorwf   EADRH,0
    btfsc   STATUS,Z                        ;高位也相等时，Z = 1,执行下一条指令;不等时，返回
    goto    L_Clear_Last
    goto    L_Clear_Page
    
L_Clear_Last:
    movlw   0E0h
    movwf   EADRL
    movlw   1Fh
    movwf   EADRH
    call    F_Clear_PageLatch               ;清除page latch
    call    F_Page_Erase                    ;页擦除
    call    F_Clear_PageLatch               ;清除page latch
    bsf     R_System_Flag,B_Execute_OK
    goto    L_Erase_Exit

L_Erase_Exit:
    clrf    TBLPEN                          ;关闭TBLP使能
    bcf     ISPCON1,ISPOF
    bsf     INTE,GIE                        ;开总中断
    return

;===========================================================
;帧数据解密
;===========================================================
;F_Decode:
;   bsf     R_System_Flag,B_Execute_OK
;   movlw   01h
;   subwf   R_RecLength,0
;   btfsc   Z
;   goto    L_Decode_End                ;若无数据区则无需解密
;   movwf   R_Decode_Count              ;确定需解密数据的长度
;
;   movlw   0B0h
;   movwf   R_ROM_AddrL
;   movlw   07h
;   movwf   R_ROM_AddrH                 ;密码表起始地址为07B0h
;   movlw   03h
;   movwf   FSR0
;   movlw   01h
;   movwf   FSR0H                       ;帧数据区起始地址为103h
;
;L_Decode_Continue:
;   call    F_ISP_Read                  ;读取解密密码
;   btfss   R_System_Flag,B_Execute_OK  ;判断密码读取是否成功
;   goto    L_Decode_End
;   incf    R_ROM_AddrL,1
;   
;   movfw   R_ROM_DataL
;   xorwf   IND0,1                      ;解密低位数据
;   incf    FSR0,1
;   decf    R_Decode_Count,1
;   btfsc   Z                           ;判断解密是否完成
;   goto    L_Decode_End
;   movfw   R_ROM_DataH
;   xorwf   IND0,1                      ;解密高位数据
;   incf    FSR0,1
;   decf    R_Decode_Count,1
;   btfss   Z
;   goto    L_Decode_Continue
;   
;L_Decode_End:
;   return
    
    
;===========================================================
;帧数据加密
;===========================================================
;F_Encrypt:
;   bsf     R_System_Flag,B_Execute_OK
;   movfwl  R_SendLength
;   sublw   01h
;   btfsc   Z
;   goto    L_Encrypt_End               ;若无数据区则无需加密
;   movwf   R_Decode_Count              ;确定需解密数据的长度
;   
;   movlw   0B0h
;   movwf   R_ROM_AddrL
;   movlw   07h
;   movwf   R_ROM_AddrH                 ;密码表起始地址为07B0h
;   movlw   04h
;   movwf   FSR0
;   movlw   03h
;   movwf   FSR0H                       ;帧数据区起始地址为304h
;   
;L_Encrypt_Continue:
;   call    F_ISP_Read                  ;读取加密密码
;   btfss   R_System_Flag,B_Execute_OK  ;判断密码读取是否成功
;   goto    L_Encrypt_End
;   incf    R_ROM_AddrL,1
;   
;   movfw   R_ROM_DataL
;   xorwf   IND0,1                      ;加密低位数据
;   incf    FSR0,1
;   decf    R_Decode_Count,1
;   btfsc   Z                           ;判断加密是否完成
;   goto    L_Encrypt_End
;   movfw   R_ROM_DataH
;   xorwf   IND0,1                      ;加密高位数据
;   incf    FSR0,1
;   decf    R_Decode_Count,1
;   btfss   Z
;   goto    L_Encrypt_Continue
;   
;L_Encrypt_End:
;   return


;===========================================================
;读取AP ROM区域数据
;===========================================================
F_ISP_APROM_Read:
    movlw   0b10000000
    movwf   BSR
    movlw   20h
    movwf   R_ISP_Round_Count
    movlw   0E0h
    subwf   R_ROM_AddrL,0
    movlw   1Fh
    subwfc  R_ROM_AddrH,0               ;判断可读取数据是否能达到64个
    btfss   STATUS,C
    goto    L_APROM_Read_Start
    movfw   R_ROM_AddrL
    sublw   0FFh
    movwf   R_ISP_Round_Count
    incf    R_ISP_Round_Count,1         ;达不到则需重新计算读取数据长度

L_APROM_Read_Start:
    movfw   R_ISP_Round_Count
    addwf   R_ISP_Round_Count,0
    addlw   01h
    movwf   R_SendLength
    movlw   84h
    movwf   FSR0                        ;帧数据区起始地址为104h
    
L_APROM_Read_Continue:
    call    F_ISP_Read                  ;读取AP ROM数据
    incf    R_ROM_AddrL,1
    btfsc   STATUS,C
    incf    R_ROM_AddrH,1
    
    movfw   R_ROM_DataL
    movwf   IND0                        ;缓存数据低位
    incf    FSR0,1
    movfw   R_ROM_DataH
    movwf   IND0                        ;缓存数据高位
    incf    FSR0,1
    decfsz  R_ISP_Round_Count,1
    goto    L_APROM_Read_Continue
    bsf     R_System_Flag,B_Execute_OK
    clrf    BSR
    return
    
    
;===========================================================
;读取版本号等信息
;===========================================================
F_Version_Read:
    movlw   10h                         ;BootLoader版本号位于0010h地址处
    movwf   R_ROM_AddrL
    clrf    R_ROM_AddrH
    call    F_ISP_Read
    movfw   R_ROM_DataL
    movwf   184h
    movfw   R_ROM_DataH
    movwf   185h                        ;缓存BootLoader版本号
    
    movlw   0F0h                        ;AP版本号存放首地址为1FF0h
    movwf   R_ROM_AddrL
    movlw   1Fh
    movwf   R_ROM_AddrH
    call    F_ISP_Read
    movfw   R_ROM_DataL
    movwf   186h
    movfw   R_ROM_DataH
    movwf   187h                        ;缓存AP版本号
    
    movlw   0F1h                        ;AP CHECKSUM位1FF1h地址处
    movwf   R_ROM_AddrL
    movlw   1Fh
    movwf   R_ROM_AddrH
    call    F_ISP_Read
    movfw   R_ROM_DataL
    movwf   188h
    movfw   R_ROM_DataH
    movwf   189h                        ;缓存AP CHECKSUM
    
    bsf     R_System_Flag,B_Execute_OK
    return

;===========================================================
;置位完整性标志位
;===========================================================
;F_APIntegrity_Flag_Set:
;   movlw   01h
;   movwf   R_ROM_AddrL
;   movlw   0F0h
;   movwf   R_ROM_AddrH
;   movlw   09h
;   movwf   R_ROM_DataL
;   movlw   03h
;   movwf   R_ROM_DataH
;   call    F_ISP_Write                         ;向NVR0 F001h地址处写入0309h
;   return


;===========================================================
; 写CHECKSUM操作
;===========================================================
/*操作步骤：关中断>清page latch>页擦除>清page latch>写page latch>页烧录>开中断*/
F_Write_Checksum:
    bcf     INTE,GIE                    ;关总中断
    movlw   0b01011010  
    movwf   TBLPEN                      ;使能TBLP操作
    movlw   0E0h
    movwf   R_ROM_AddrL                 ;CHECKSUM存放在最后一页
    movlw   1Fh
    movwf   R_ROM_AddrH

    call    F_Clear_PageLatch           ;清除page latch
    movfw   R_ROM_AddrL
    movwf   EADRL                       ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                       ;赋写地址高位
    call    F_Page_Erase                ;页擦除
    call    F_Clear_PageLatch           ;清除page latch

L_Write_Data:
    movlw   20h                         ;Row0与最后一页地址偏差0020h 
    addwf   R_ROM_AddrL,0
    movwf   EADRL
    movlw   20h                         ;Row0起始地址为2000h
    movwf   EADRH
    movp                                ;读取数据
    nop
    movwf   R_ROM_DataL                 ;读数据低位

L_Modify_Page_Latch:
    movfw   R_ROM_AddrL
    movwf   EADRL                       ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                       ;赋写地址高位
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT                       ;解锁TBLP操作
    movfw   R_ROM_DataL                 ;准备数据低位
    tblp    69h                         ;写page latch
    nop
    
    incf    R_ROM_AddrL,1
    movlw   0F1h                        ;1FF0h为AP版本号,1FF1h为CHECKSUM
    subwf   R_ROM_AddrL,0
    btfss   STATUS,C
    goto    L_Write_Data                ;保留区前数据从RAW0区域读取,地址低位< F1h时，返回复制数据
    movlw   0F1h
    xorwf   R_ROM_AddrL,0
    btfss   STATUS,Z                    ;地址低位==F1h时,异或结果为0,Z=1,跳转，写checksum
    goto    L_Integrity_Fill_Judge      ;地址低位>F1h时,Z=0, 跳转判断
    movfw   104h                        ;1FF1h地址处CHECKSUM从接收缓存区获取
    movwf   EDATH
    movfw   105h
    movwf   R_ROM_DataL                 ;???反了???因为在flsh写数据的时候每个word是先高后低，所以缓存区数据是的checksum也是先高字节后低字节存储
    goto    L_Modify_Page_Latch

L_Integrity_Fill_Judge:
    movlw   0F5h
    xorwf   R_ROM_AddrL,0
    btfss   STATUS,Z
    goto    L_Reserved_Fill             ;地址低位!= 0F5h,Z=0;填充00
    movlw   5Ah                         ;1FF5h地址处完整性标志填充
    movwf   EDATH
    clrf    R_ROM_DataL
    goto    L_Modify_Page_Latch

L_Reserved_Fill:
    clrf    EDATH
    clrf    R_ROM_DataL
    movlw   0FFh
    xorwf   R_ROM_AddrL,0
    btfss   STATUS,Z
    goto    L_Modify_Page_Latch
    movfw   R_ROM_AddrL
    movwf   EADRL                       ;赋写地址低位
    movfw   R_ROM_AddrH
    movwf   EADRH                       ;赋写地址高位
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT                       ;解锁TBLP操作
    movfw   R_ROM_DataL                 ;准备数据低位
    tblp    69h                         ;写page latch
    nop

    movlw   0E0h
    movwf   EADRL                       ;赋写地址低位
    movlw   1Fh
    movwf   EADRH                       ;赋写地址高位
    call    F_Page_Write                ;页烧录
    bsf     R_System_Flag,B_Execute_OK
    btfsc   ISPCON1,ISPOF                       ;判断校验是否正确
    bcf     R_System_Flag,B_Execute_OK
    bcf     ISPCON1,ISPOF
    clrf    BSR
    clrf    TBLPEN              ;关闭TBLP使能
    bsf     INTE,GIE            ;开总中断
    return

;===========================================================
;跳转校验
;===========================================================
F_Jump_Judge:
    movlw   0F5h
    movwf   R_ROM_AddrL
    movlw   1Fh
    movwf   R_ROM_AddrH                         ;完整性标志位位于1FF5地址处
    call    F_ISP_Read                          ;读取完整性标志
    bsf     R_System_Flag,B_APIntegrity_Fail
    movlw   5Ah
    xorwf   R_ROM_DataH,0
    btfsc   STATUS,Z
    bcf     R_System_Flag,B_APIntegrity_Fail
    return
    
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movlw   09h
;   xorwf   R_ROM_DataL,0
;   btfss   Z
;   goto    L_FLASH_Change_Judge                ;若完整性标志未置位，则检查FLASH是否被改写过
;   movlw   03h
;   xorwf   R_ROM_DataH,0
;   btfsc   Z
;   goto    L_APVersion_Check                   ;完整性标志置位后确认AP版本号是否一致
;   
;L_FLASH_Change_Judge:
;   movlw   03h
;   movwf   R_ROM_AddrL
;   movlw   0F0h
;   movwf   R_ROM_AddrH                         ;FLASH改写标志位于F003地址处
;   call    F_ISP_Read                          ;读取FLASH改写标志
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movlw   0AAh
;   xorwf   R_ROM_DataL,0
;   btfss   Z
;   goto    L_CSWrite_Check                     ;FLASH未改写则需检查AP程序是否由烧录器写入
;   movlw   55h
;   xorwf   R_ROM_DataH,0
;   btfss   Z
;   goto    L_CSWrite_Check
;   goto    L_Jump_Judge_Erro                   ;完整性标志未置位，FLASH改写标志置位则说明程序未经校验，不允许跳转
;
;L_APVersion_Check:
;   movlw   10h
;   movwf   R_ROM_AddrL
;   movlw   08h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Read                          ;读取AP版本号
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movfw   R_ROM_DataL
;   movwf   R_APVersion_Temp1
;   movfw   R_ROM_DataH
;   movwf   R_APVersion_Temp2                   ;缓存AP版本号
;   
;   clrf    R_ROM_AddrL
;   movlw   0F0h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Read                          ;读取NVR0区域AP版本号
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movfw   R_APVersion_Temp1
;   xorwf   R_ROM_DataL,0                       ;比对版本号
;   btfss   Z
;   goto    L_CSWrite_Check                     ;版本号不一致则需检查AP程序是否由烧录器写入
;   movfw   R_APVersion_Temp2
;   xorwf   R_ROM_DataH,0
;   btfsc   Z
;   goto    F_Jump_Judge_End                    ;完整性标志置位且版本号一致则进行跳转
;
;L_CSWrite_Check:
;   movlw   11h
;   movwf   R_ROM_AddrL
;   movlw   08h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Read                          ;读取升级方式标志位
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movlw   3Ch
;   xorwf   R_ROM_DataL,0
;   btfss   Z
;   goto    L_Jump_Judge_Erro                   ;AP不是由烧录器写入，则说明AP区域异常，不允许跳转
;   movlw   5Ah
;   xorwf   R_ROM_DataH,0
;   btfss   Z
;   goto    L_Jump_Judge_Erro
;   
;   clrf    R_ROM_AddrL
;   movlw   0F0h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Sector_Erase                  ;擦除NVR0区域，清除FLASH改写标志
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   call    F_AP_Infomation_Copy                ;复制AP版本号
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movlw   03h
;   movwf   R_ROM_AddrL
;   movlw   0F8h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Read                          ;读取烧录器写入的CHECKSUM值
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   movlw   02h
;   movwf   R_ROM_AddrL
;   movlw   0F0h
;   movwf   R_ROM_AddrH
;   call    F_ISP_Write                         ;将读取的CHECKSUM复制至NVR0区域F002h地址处
;   btfss   R_System_Flag,B_Execute_OK
;   goto    L_Jump_Judge_Erro
;   call    F_APIntegrity_Flag_Set              ;置位完整性标志位
;   btfsc   R_System_Flag,B_Execute_OK
;   goto    F_Jump_Judge_End
;
;L_Jump_Judge_Erro:
;   bsf     R_System_Flag,B_APIntegrity_Fail
;   
;F_Jump_Judge_End:
;   return

F_Page_Erase:
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT               ;解锁TBLP操作
    tblp    0A5h                ;页擦除
    nop
    return

F_Clear_PageLatch:
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT               ;解锁TBLP操作
    tblp    5Ah                 ;清除page latch
    nop
    return
    
F_Page_Write:
    movlw   96h
    movwf   WRPRT
    movlw   69h
    movwf   WRPRT
    movlw   5Ah
    movwf   WRPRT               ;解锁TBLP操作
    tblp    96h                 ;页烧录
    nop
    nop
    return


;org    07B0h                       ;密码表
;dw 0x4703
;dw 0xC87E
;dw 0x8178
;dw 0x42C4
;dw 0xCE6B
;dw 0x167D
;dw 0x4370
;dw 0x1B76
;dw 0x8569
;dw 0x3846
;dw 0xDB4C
;dw 0x1B34
;dw 0x8727
;dw 0x2E55
;dw 0x5761
;dw 0xC7F5
;dw 0x7742                      ;07C0h
;dw 0xA038
;dw 0x89B5
;dw 0x8601
;dw 0xF74D
;dw 0x5513
;dw 0x8887
;dw 0x2377
;dw 0x324F
;dw 0xBC1D
;dw 0x30C5
;dw 0x4FC6
;dw 0x5440
;dw 0x6620
;dw 0x9D93
;dw 0x1B33
;dw 0x0C90                      ;07D0h
;dw 0x89FD
;dw 0xB4CB
;dw 0x8259
;dw 0x11A1
;dw 0x8026
;dw 0x9A78
;dw 0xDDA4

.ends
    
    