﻿include "CS8M320.inc"

;============================================
;系统初始化函数        
;============================================
F_Sys_Init:
    call    F_WDT_Init                  ;看门狗、状态寄存器初始化
    call    F_GPIO_Init                 ;IO口初始化
    call    F_Timer_Init                ;定时器初始化
    call    F_UART_Init                 ;UART初始化
    call    F_INT_Init                  ;中断初始化  
    return


;============================================
;跳转初始化函数        
;============================================
;============================================
;清Bank程序宏定义     
;============================================
M_Clear_Banky   .macro  bankx_start_addr,bankx_end_addr
    movlw   bankx_start_addr
    movwf   FSR0
    clrf    IND0
    incf    FSR0,1
    movlw   bankx_end_addr
    subwf   FSR0,0
    btfss   STATUS,C
    goto    $-5
    clrf    IND0
.endm

F_Junp_Init:
;    call    F_RAM_Clear
    bcf     INTE,GIE            ;关闭总中断
    
    clrf    BSR                 ;选择操作PAGE0前256Byte地址
    M_Clear_Banky   80h,0FFh    ;清零bank0
    movlw   80h
    movwf   BSR                 ;选择操作PAGE0后256Byte地址
    M_Clear_Banky   00h,0FFh    ;清零bank1
    movlw   81h
    movwf   BSR                 ;选择操作PAGE1后256Byte地址
    M_Clear_Banky   00h,67h     ;清零bank3
    
    clrf    BSR
    clrf    WDTCON
    bsf     MCK,CST_WDT
    clrf    TM0CON
    movlw   0b11111111
    movwf   TM0IN
    clrf    UR0_CR1
    clrf    UR0_BRR0
    clrf    UR0_BRR1
    clrf    UR0_INTE
    clrf    UR0_INTF
;   bcf     PT3PU,PT3PU_1    
    bcf     INTE,GIE
    return

;============================================
;清Bank程序宏定义     
;============================================
M_Clear_Bankx   .macro  bankx_start_addr,bankx_end_addr
    movlw   bankx_start_addr
    movwf   FSR0
    clrf    IND0
    incf    FSR0,1
    movlw   bankx_end_addr
    subwf   FSR0,0
    btfss   STATUS,C
    goto    $-5
    clrf    IND0
.endm

;============================================
;RAM清零函数        
;============================================
F_RAM_Clear:
    bcf     INTE,GIE            ;关闭总中断
    
    clrf    BSR                 ;选择操作PAGE0前256Byte地址
    M_Clear_Bankx   80h,0FFh    ;清零bank0
    movlw   80h
    movwf   BSR                 ;选择操作PAGE0后256Byte地址
    M_Clear_Bankx   00h,0FFh    ;清零bank1
    movlw   81h
    movwf   BSR                 ;选择操作PAGE1后256Byte地址
    M_Clear_Bankx   00h,67h     ;清零bank3
    
    clrf    BSR
    bsf     INTE,GIE            ;开启总中断
    return


;============================================
;系统时钟及WDT初始化函数      
;============================================
F_WDT_Init:
    clrf    BSR
    clrf    STATUS              ;清零状态寄存器
    clrf    MCK                 ;打开内部32KHz晶振
    
    clrf    STATUS              ;清零状态寄存器
    movlw   0FFh
    movwf   WDTIN
    movlw   0b10000001
    movwf   WDTCON              ;开启看门狗，超时时间为1024ms
    clrwdt
    return


;============================================
;GPIO初始化函数      
;============================================
F_GPIO_Init:
    bcf     METCH,METCH0
    bcf     PT3CON,PT3CON_1
    bcf     PT3EN,PT3EN_1
;   bsf     PT3PU,PT3PU_1
    return


;============================================
;Timer初始化函数     
;============================================
F_Timer_Init:
    movlw   0b11110001
    movwf   TM0CON
    movlw   0FFh
    movwf   TM0IN       ;溢出时间1ms
    return


;============================================
;UART初始化函数      
;============================================
F_UART_Init:
    movlw   0b00001000
    movwf   UR0_CR1
    movlw   0b00100011
    movwf   UR0_BRR1
    movlw   0D0h
    movwf   UR0_BRR0            ;UART时钟源MCK/8=4MHz，波特率19200
    movlw   0b00100000
    movwf   UR0_ST              ;PT3.1初始化为RX
    clrf    UR0_INTF
;   movlw   0b00010100          ;开启UART接收错误中断和接收FIFO非空中断
    movlw   0b00000100          ;开启UART接收接收FIFO非空中断
    movwf   UR0_INTE
    bsf     UR0_CR1,UART0_EN
    return


;============================================
;Interrupt初始化函数     
;============================================
F_INT_Init:
    clrf    INTF
    clrf    INTF2
    clrf    INTE2
    movlw   0b10010000
    movwf   INTE                ;使能总中断、定时器0中断
    return
