﻿/**********************************
* @file adc.c
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CS8M320.h"
#include "adc.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void adc_init(void)
* @brief ADC init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void adc_init(void);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
static void delay_us(void);

/***********************************
* @fn  unsigned int adc_get_result(void)
* @brief get ADC result .
* @param[out] result.
* @param[in] channel.
* @return none.
************************************/
unsigned int adc_get_result(unsigned char channel);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

static void delay_us(void)
{
	unsigned char j;
	for(j = 250;j > 0;j--);
}

/***********************************
* @fn  void adc_init(void)
* @brief ADC init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void adc_init(void)
{
	set_adc_clk(); //ADC时钟为cpuclk/4，2MHz/4=500KHZ
	set_adc_samp(); //采样时间为4个ADC时钟
  	OFTEN = 0;
  	CALIF = 0;		//未开启校准
    ADC2V_EN = 0;   //设置内部参考电压为1.22V
  	ENOV = 0;
  	OFFEX = 0; 
  	adc_enable();
}

/***********************************
* @fn  unsigned int adc_get_result(void)
* @brief get ADC result .
* @param[out] result.
* @param[in] channel.
* @return none.
************************************/
unsigned int adc_get_result(unsigned char channel)
{
	static unsigned char conver_times = 0;
	static unsigned int result = 0;
	static unsigned char mode = 3;
	static unsigned long int result_temp = 0;
	SARVCMSEL = 0;		//差分采样共模电压小于1/2VREFF或单端采样时置0，否则置1
	switch(mode)
	{
		case 0:			 //vref:VDD
		{ 
			VREFS_0 = 0;
			VREFS_1 = 0;
			adc_channel(channel);
		}break;
		
		case 1:			 //vref:PT3.0
		{
			PT3EN_0 = 0;	//PT3.0为模拟输入口
			PT3PU_0 = 0;
			PT3CON_0 = 1;
			
			VREFS_0 = 1;
			VREFS_1 = 0;
			adc_channel(channel);
		}break;
		
		case 2:			//vref:内部基准1.22V
		{
			VREFS_0 = 0;
			VREFS_1 = 1;
			adc_channel(channel);
		}break;
		
		case 3:			//vref:VDD,测内部1.22V
		{
			VREFS_0 = 0;
			VREFS_1 = 0;
			adc_channel(0xD0);
		}break;
		
		default : mode = 0;
	}
	
	for(conver_times = 0; conver_times < 8; conver_times++)
	{
		adc_start_conver();
		while(SRADS);
		result = (SRADH << 8) | SRADL; //获取转换结果
		result_temp += result;
	}
	
	conver_times = 0;
	result = result_temp >> 3;
	result_temp = 0;

	return result;
}

