﻿/**********************************
* @file timer0.h
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _TIMER0_H
#define  _TIMER0_H 

/* Includes 
------------------------------------------------------------------*/
#include "CS8M320.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER0_COUNT
* @brief define TIMER0 COUNT
* Details.
*/
#define TIMER0_COUNT        250  //500HZ 


/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer0_enable()
* @brief set timer0 enable
* Details.
*/
#define timer0_enable()     {T0EN = 1;}

/**
* @def timer0_div()
* @brief set timer0 div 32
* Details.
*/
#define timer0_div()          {T0RATE_0 = 1;T0RATE_1 = 0;T0RATE_2 = 1;}

/**
* @def timer0_count_clr()  
* @brief timer0 count clear
* Details.
*/
#define timer0_count_clr()        {T0RSTB = 0;}

/**
* @def timer0_clk_select()
* @brief set timer0 clk source select
* Details.
*/
#define timer0_clk_select()          {T0SEL_0 = 0;T0SEL_1 = 0;}


/**
* @def timer0_int_enable()  
* @brief enable timer0 int 
* Details.
*/
#define timer0_int_enable()       {TM0IF = 0;TM0IE = 1;GIE = 1;}


/* Exported functions 
--------------------------------------------------------*/

extern void timer0_init(void);


#endif