﻿//============================================
// filename: main.c
// chip    : CS8M320
// author  :
// date    : 2023-07-26
//============================================
#include "CS8M320.h"
#include "isp.h"

/*-------------------------------ISP Demo例程介绍--------------------------
（1）向write_address[5]中的FLASH地址写入数据
（2）将write_address[5]地址的FLASH数据读出存到read_data[5]
（3）改写change_address[3]地址处的数据
（4）将write_address[5]地址的FLASH数据读出存到read_data[5]
可在Debug状态下，打断点，调试检测读写正确性。
---------------------------------------------------------------------------------*/

sbit uart_trans_1byte_ok;

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
    ;
}

//============================================
// program start
//============================================
void main()
{
	unsigned int write_data[5]={0xCA10,0x054C,0xA32B,0x20F5,0x07AB};		//写入FLSAH的数据
	unsigned int write_address[5]={0x1C05,0x1C07,0x1C10,0x1C13,0x1C15};		//FLSAH写入地址，注意一次操作时这些地址应当位于同一片区，数目不超过32个
	unsigned int change_data[3]={0x10AC,0x1A5C,0x27A2};						//FLSAH更改的数据
	unsigned int change_address[3]={0x1C05,0x1C10,0x1C15};		//FLSAH更改数据的地址，注意一次操作时这些地址应当位于同一片区，数目不超过32个
	unsigned int read_data[5]={0};
	unsigned char i = 0;
	unsigned char j = 0;
	TBLPEN = 0x5A;
	write_flash(write_address,write_data,5);
	for(i=0;i<5;i++)
	{
		read_data[i] = read_flash(write_address[i]);
	}
	change_data_flash(change_address,change_data);
	for(i=0;i<5;i++)
	{
		read_data[i] = read_flash(write_address[i]);
	}
	while(1);
}
