﻿//============================================
// filename: main.c
// chip    : CS8M320
// author  :
// date    : 2023-07-26
//============================================
#include "CS8M320.h"
#include "sleep.h"

/*-------------------------------Sleep Demo例程介绍-------------------------------
借助IDE Debug调试Sleep
在
enter_sleep()函数的asm("sleep");处打断点。
Debug模式下：
（1）PT1.0接到GND，开始全速运行
（2）程序在asm("sleep");处被打断，点击继续运行，芯片进入睡眠
（3）手动将PT1.0接到VDD再接回GND，构建下降沿。
（4）芯片唤醒，会观察到程序在asm("sleep");处被打断，点击继续运行，芯片再次进入睡眠
---------------------------------------------------------------------------------*/

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(E1IF && E1IE)
	{
		E1IF = 0;
	}
}

//============================================
// program start
//============================================
void main()
{
	enter_sleep();		//PT1.5为数字输入口，接上拉，可用于唤醒
}
