﻿/**********************************
* @file sleep.c
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CS8M320.h"
#include "sleep.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void enter_sleep(void)
* @brief enter sleep mode.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void enter_sleep(void);

/***********************************
* @fn  void enter_sleep(void)
* @brief enter sleep mode.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void enter_sleep(void)
{
	PT1 = 0;		//PT1.5为数字输入口，接上拉，使能PT1.5外部中断，其余全部设置为数字输出0，无上拉
	PT1EN = 0x19;
	PT1PU = 0x20; 
	PT1CON1 = 0;

	PT3 = 0;		//PT3全部设置为数字输出0，无上拉
	PT3EN = 0x7F;
	PT3PU = 0;  
	PT3CON = 0;

	PT5 = 0;		//PT5全部设置为数字输出0，无上拉
	PT5EN = 0xFF;
	PT5PU = 0;  
	PT5CON = 0;
	
	PT1CON = 0x24;	//PT1.5下降沿触发中断
	PT5CON1 = 0;	//禁止外部中断1
	INTCFG = 0;		//禁止外部中断0和外部中断1
	
	SRADCON0 = 0x40;
	SRADCON1 = 0x02;
	SRADCON2 = 0x01;	
	CST_WDT = 1;	//关闭WDT时钟
	I2CCON = 0;
	UR0_CR1 = 0;
	

	wakeup_check:
		while(PT1_5);
		E1IF = 0;  //clr int1 flag
		E1IE = 1;  // enable int1 
		E0IF = 0;  //clr int1 flag
		E0IE = 1;  // enable int1 
		GIE = 1;
		asm("sleep"); // enter sleep mode
		asm("nop");
		E1IE = 0;
		goto wakeup_check;   
}

