﻿//============================================
// filename: main.c
// chip    : CS8M320
// author  :
// date    : 2023-07-26
//============================================
#include "CS8M320.h"
#include "timer3.h"

/*-------------------------------Timer3 Demo例程介绍-------------------------------
可配置的初始化测试模式：mode
（1） mode = 0，测试Timer3普通计数功能：
       计数器溢出时PT1.0电平翻转，芯片工作时用示波器抓取PT1.0电平信号，校验Timer计数周期。
（2） mode = 0，测试正常PWM模式下IO输出PWM信号功能：
       配置PT3.5做Timer3第一路正常模式PWM输出，芯片工作时用示波器抓取PT3.5电平信号，校验PWM周期和占空比。
       用户可改配PWM输出口、周期、占空比。
（3） mode = 1，测试蜂鸣器输出功能：
       配置PT3.5做Timer3蜂鸣器输出，芯片工作时用示波器抓取PT3.5电平信号，校验PWM周期。
（4） mode = 2，测试互补PWM模式下IO输出PWM信号功能：
       配置PT5.1和PT5.0做Timer3第二路互补模式PWM输出，芯片工作时用示波器抓取该两个IO的电平信号，
     校验PWM周期和占空比。
       用户可改配PWM输出口、周期、占空比。
---------------------------------------------------------------------------------*/

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM3IF && TM3IE)
	{
		TM3IF = 0;
		PT1_0 = ~PT1_0;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char mode = 0;
	GIE = 0;
	timer3_init();
	PWM3STALL = 0;	//ICD调试stall（例如单步）时，定时器3单端PWM输出低电平，此配置取决于外围硬件情况，用于在芯片调试暂停时保护外围硬件不会受损
	switch(mode)
	{
		case 0:		//计数器模式
		{		
			PT1EN_0 = 1;	//PT1.0为数字输出口，无上拉
			PT1PU_0 = 0;
			PT1CON_0 = 0;
			PT1_0 = 0;
			
			T3OUT = 0;		//PT3.5为普通IO口
			PWM3OUT = 0;
			
			timer3_pwm_period(TIMER3_COUNT);	//4ms溢出一次
		}break;
				
		case 1:		//正常PWM模式
		{
			PT5EN_1 = 1;	//PT5.1为PWM3输出口,数字输出口，无上拉
			PT5PU_1 = 0;
			PT5CON_1 = 0;

			PWM3PO1 = 1; //PT5.1为PWM第一个正常模式输出口

			T3OUT = 0;	//PWM输出
			PWM3OUT = 1;
			
			timer3_pwm_period(TIMER3_COUNT);		//PWM频率250Hz
			TM3R1 = (unsigned char)(TIMER3_PWM_DUTY_50 & 0x00ff);   //PWM占空比50%
			TM3R3 |= (unsigned char)((TIMER3_PWM_DUTY_50 >> 8)& 0x000f);
			
			
		}break;
				
		case 2:		//蜂鸣器模式
		{
			PT3EN_5 = 1;	//PT3.5为蜂鸣器输出口,数字输出口，无上拉
			PT3PU_5 = 0;
			PT3CON_5 = 0;
			
			PWM3PO1 = 0; //PT3.5为输出口
			
			T3OUT = 1;	//蜂鸣器输出
			PWM3OUT = 0;
			
			T3RATE_0 = 0;
			T3RATE_1 = 0;
			T3RATE_2 = 1;		
			T0SEL_0 = 1;
			T0SEL_1 = 0;    //时钟修改为MCK/16，2MHz
			
			timer3_pwm_period(TIMER3_COUNT);	//8KHZ/2=4KHz
		}break;
				
		case 3:		//互补PWM模式
		{
			PT5EN_0 = 1;	//PT5.0为PWM3_L输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT5CON_0 = 0;
			PT5EN_1 = 1;	//PT5.1为PWM3_H输出口,数字输出口，无上拉
			PT5PU_1 = 0;
			PT5CON_1 = 0;
			
			P3L2OEN = 1;
			P3L2INV = 1;
			P3H2OEN = 1;
			P3H2INV = 0;
			
			timer3_dt_enable();
			timer3_dt_clk();	//MCK/4=8MHZ
			timer3_dt_time(TIMER3_DT_TIME);		//死区时间为250ns
			
			T3RATE_0 = 0;
			T3RATE_1 = 0;
			T3RATE_2 = 0;
			T0SEL_0 = 1;    //时钟修改为MCK，32MHz
			T0SEL_1 = 0;
			timer3_pwm_period(TIMER3_COUNT);		//128KHz
			TM3R2 = (unsigned char)(TIMER3_PWM_DUTY_50 & 0x00ff);   //PWM占空比
			TM3R3 |= (unsigned char)((TIMER3_PWM_DUTY_50 >> 8)& 0x00f0);
		}break;
		
		default : mode = 0;
	}
	timer3_count_clr();
	timer3_enable();
	timer3_int_enable();
	while(1);
}
