﻿;============================================
; filename: csu32m10_adc_offset.asm
; chip    : CSU32M10
; author  :
; date    : 2019-04-25
;============================================
include "CSU32M10.inc"

count_temp  equ  0x80
;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
delay_uS:                  
	nop
 	movlw 200
	movwf count_temp
loop_delay:
	nop
	decfsz count_temp,1
	goto  loop_delay	
	return
	
;============================================
; main program 
;============================================ 
Prog_Start:  
	movlw 0F0H
    movwf EADRH 
    movlw 03H
    movwf EADRL 
    movp ;read adc offset
    nop
    movwf SROFTL ;store adc offset in SROFTL
    movlw 00H
    movwf SROFTH
    bsf PT1EN,PT1EN_0
    bsf PT1EN,PT1EN_1
    bcf PT1,PT1_0
    bcf PT1,PT1_1
loop_main:

bit7_deal:
    btfsc PT1,PT1_0
    goto bit7_low_clk_level    ;set bit7 clk
    goto bit7_high_clk_level
bit7_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit0
bit7_high_clk_level:
	bsf   PT1,PT1_0
output_bit7:	
    btfss SROFTL,SROFT_7
    goto bit7_low_dat_level  ;output bit7
    goto bit7_high_dat_level
bit7_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit6_deal
bit7_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit6_deal:
    btfsc PT1,PT1_0
    goto bit6_low_clk_level  ;set bit6 clk
    goto bit6_high_clk_level
bit6_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit6
bit6_high_clk_level:
	bsf   PT1,PT1_0
output_bit6:	
    btfss SROFTL,SROFT_6
    goto bit6_low_dat_level ;output bit6
    goto bit6_high_dat_level
bit6_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit5_deal
bit6_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit5_deal:
    btfsc PT1,PT1_0
    goto bit5_low_clk_level  ;set bit5 clk
    goto bit5_high_clk_level
bit5_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit5
bit5_high_clk_level:
	bsf   PT1,PT1_0
output_bit5:	
    btfss SROFTL,SROFT_5
    goto bit5_low_dat_level  ;output bit5
    goto bit5_high_dat_level
bit5_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit4_deal
bit5_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit4_deal:
    btfsc PT1,PT1_0
    goto bit4_low_clk_level  ;set bit4 clk
    goto bit4_high_clk_level
bit4_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit4
bit4_high_clk_level:
	bsf   PT1,PT1_0
output_bit4:	
    btfss SROFTL,SROFT_4
    goto bit4_low_dat_level ;output bit4
    goto bit4_high_dat_level
bit4_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit3_deal
bit4_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit3_deal:
    btfsc PT1,PT1_0
    goto bit3_low_clk_level  ;set bit3 clk
    goto bit3_high_clk_level
bit3_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit3
bit3_high_clk_level:
	bsf   PT1,PT1_0
output_bit3:	
    btfss SROFTL,SROFT_3
    goto bit3_low_dat_level  ;output bit3
    goto bit3_high_dat_level
bit3_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit2_deal
bit3_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit2_deal:
    btfsc PT1,PT1_0
    goto bit2_low_clk_level  ;set bit2 clk
    goto bit2_high_clk_level
bit2_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit2
bit2_high_clk_level:
	bsf   PT1,PT1_0
output_bit2:	
    btfss SROFTL,SROFT_2
    goto bit2_low_dat_level  ;output bit2
    goto bit2_high_dat_level
bit2_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit1_deal
bit2_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
    
bit1_deal:
    btfsc PT1,PT1_0
    goto bit1_low_clk_level  ;set bit1 clk
    goto bit1_high_clk_level
bit1_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit1
bit1_high_clk_level:
	bsf   PT1,PT1_0
output_bit1:	
    btfss SROFTL,SROFT_1
    goto bit1_low_dat_level ; output bit1
    goto bit1_high_dat_level
bit1_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
    goto  bit0_deal
bit1_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS 
    
bit0_deal:
    btfsc PT1,PT1_0
    goto bit0_low_clk_level   ;set bit0 clk
    goto bit0_high_clk_level
bit0_low_clk_level:
	bcf   PT1,PT1_0
	goto  output_bit0
bit0_high_clk_level:
	bsf   PT1,PT1_0
output_bit0:	
    btfss SROFTL,SROFT_0    ;output bit0
    goto bit0_low_dat_level
    goto bit0_high_dat_level
bit0_low_dat_level:
	bcf   PT1,PT1_1
	call  delay_uS
	goto  data_output_end
bit0_high_dat_level:
	bsf   PT1,PT1_1
    call  delay_uS
data_output_end:
    call  delay_uS 
    call  delay_uS 
    call  delay_uS 
	goto loop_main	
.end