﻿;============================================
; filename: csu32m10_constant-current_source.asm
; chip    : CSU32M10
; author  :
; date    : 2019-04-25
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bcf   PT3PU,PT3PU_2         ;disable pull up
	bcf   PT3PD,PT3PD_2         ;disable pull down
	bsf   CCSCON,CCSOEN         ;enable current source
	goto $						; loop forever
.end