﻿;============================================
; filename: csu32m10_gpio.asm
; chip    : CSU32m10
; author  :
; date    : 2019-02-13
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends

;============================================
; Demo_gpio_flip program 
;============================================ 
Demo_gpio_flip:
	btfss PT1,PT1_1
	goto  low_level
	goto  high_level
low_level:
	bcf   PT1,PT1_0
	return
high_level:
	bsf   PT1,PT1_0
	return

;============================================
; main program 
;============================================ 
Prog_Start:  
	movlw 0x01
	movwf PT1EN                 ;PT1_0:out  PT1_1:in
	bsf   PT1PU,PT1PU_1         ;PT1_1:pull-up
loop:
	call  Demo_gpio_flip
	goto  loop
.end
