;============================================
; filename: csu32M10_halt.asm
; chip    : CSU32M10
; author  :
; date    : 2019-02-28
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
	btfss INTF,TM0IF
	goto  end_int
	bcf   INTF,TM0IF
end_int:
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bsf PT1EN,PT1EN_1           ;PT1_1:out high
	bcf MCK,CST_WDT             ;OPEN 32K
	movlw 0x72
	movwf TM0CON
	movlw 249
	movwf TM0IN                 ;(249+1)/(32KHz/128)=1S
	bsf   TM0CON,T0EN           ;enable timer0
	bsf   INTE,TM0IE            ;enable timer0 interrupt
	bsf   INTE,GIE              ;enable interrupt
loop:	
	bcf PT1,PT1_1
	halt
	bsf PT1,PT1_1
	goto loop
.end