﻿;============================================
; filename: csu32m10_timer3.asm
; chip    : CSU32M10
; author  :
; date    : 2019-02-25
;============================================
include "CSU32M10.inc"

DEFINE  PERIOD_PWM3         (80-1)    ;200KHz
DEFINE  DUTY_CYCLE_20_PWM3  (16-1)     ;20%
DEFINE  DUTY_CYCLE_80_PWM3  (64-1)    ;80%

DEFINE  IO_PWM3             1       ;IO_PWM3=1:pt5.0/pt5.1    IO_PWM3=0:pt3.5/pt1.0    

tm3rh_temp   equ 0x80
tm3r_temp    equ 0x81

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
	btfss INTF2,TM3IF
	goto  end_int
	bcf   INTF2,TM3IF            ;clear tm3if
	movlw  low DUTY_CYCLE_80_PWM3      ; 2000 80%
	subwf  tm3r_temp,0
	movlw  high DUTY_CYCLE_80_PWM3
	subwfc tm3rh_temp,0
	btfsc STATUS,C
	goto  int_tm3r
	goto  add_tm3r
int_tm3r:
	movlw  high DUTY_CYCLE_20_PWM3    ; 500 20%
	movwf  tm3rh_temp
	movlw  low DUTY_CYCLE_20_PWM3
	movwf  tm3r_temp
	goto   set_tm3r
add_tm3r:
	movlw 1
	addwf tm3r_temp,1
	movlw 0
	addwfc tm3rh_temp,1
set_tm3r:
	movfw  tm3rh_temp
	movwf  TM3RH 
	movfw  tm3r_temp
	movwf  TM3R
end_int:
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bsf    METCH,T3RATE_3       ; MCK
if  IO_PWM3 == 1
	bsf    PT5EN,PT5EN_0          ; PT5_0:out pwm3l
	bsf    PT5EN,PT5EN_1          ; PT5_1:out pwm3h
	movlw  0x01
	movwf  TM3CON
else
	bsf    PT3EN,PT3EN_5          ; PT3_5:out pwm3l
	bsf    PT1EN,PT1EN_0          ; PT1_0:out pwm3h
	movlw  0x00
	movwf  TM3CON
endif
	movlw  high PERIOD_PWM3
	movwf  TM3INH 
	movlw  low PERIOD_PWM3
	movwf  TM3IN                ; (79+1)/16MHz=5uS=200KHz
	
	movlw  high DUTY_CYCLE_20_PWM3
	movwf  TM3RH 
	movwf  tm3rh_temp
	movlw  low DUTY_CYCLE_20_PWM3
	movwf  TM3R                 ; 500 20%
	movwf  tm3r_temp
if  IO_PWM3 == 1	
	movlw  0x27
	movwf  TM3CON2
	movlw  0x00
	movwf  TM3CON3
else
	movlw  0x24
	movwf  TM3CON2
	movlw  0x03
	movwf  TM3CON3
endif
	bsf    TM3CON,T3EN
	bsf    INTE2,TM3IE
	bsf    INTE,GIE
loop:	
	goto $						; loop forever	
.end