﻿;============================================
; filename: csu32m10_wdt.asm
; chip    : CSU32M10
; author  :
; date    : 2019-03-08
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bcf MCK,CST_WDT         ;open wdtclk
	movlw 0xff
	movwf WDTIN
	movlw 0x87
	movwf WDTCON            ;16ms
	bsf   PT1EN,PT1EN_0     ;PT1.0:out
	bsf   PT1,PT1_0         ;high
loop:
	clrwdt
	nop
	nop
	goto loop				
.end