﻿/**********************************
* @file csu32m10_eeprom.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_eeprom.h"

/* Fuction Declare ----------------------------------------------------------*/

/**********************************
* @fn  unsigned char csu32m10_write_eeprom(unsigned int address,unsigned char write_data)
* @brief write data to eeprom
* @param[out] none.
* @param[in] none.
* @return none.
**********************************/
unsigned char csu32m10_write_eeprom(unsigned int address,unsigned char write_data);

/**********************************
* @fn  csu32m10_read_eeprom(unsigned int address)
* @brief read data from eeprom
* @param[out] none.
* @param[in] none.
* @return none.
**********************************/
unsigned char csu32m10_read_eeprom(unsigned int address);

/* Fuction Define -----------------------------------------------------------*/

/**********************************
* @fn  unsigned char csu32m10_write_eeprom(unsigned int address,unsigned char write_data)
* @brief write data to eeprom
* @param[out] none.
* @param[in] none.
* @return none.
**********************************/

unsigned char csu32m10_write_eeprom(unsigned int address,unsigned char write_data)
{
    unsigned char address_buf[2]={0};
    address_buf[0] = (unsigned char)(address >> 8);
	address_buf[1] = (unsigned char)(address&0x00ff);
	EADRH = address_buf[0]; // write address
    EADRL = address_buf[1];
    GIE = 0; // disable inttrupt
    asm("CLRWDT"); // clr wdt cnt
    asm("NOP");
    asm("NOP");
    asm("NOP");
    WRPRT = 0x96; // unlock
    WRPRT = 0x69;
    WRPRT = 0x5A;
    while(!WRPRTF); 
    WORK = write_data;
    asm ("TBLP 0H"); //write data
    asm ("NOP");
    asm ("NOP");
    if(CHKRSLT)
    {
      return WRITE_ERROR_NONE;
    }
    else
    {
      return WRITE_ERROR;
    }
}

/**********************************
* @fn  csu32m10_read_eeprom(unsigned int address)
* @brief read data from eeprom
* @param[out] none.
* @param[in] none.
* @return none.
**********************************/

unsigned char csu32m10_read_eeprom(unsigned int address)
{
    static unsigned char read_data = 0;
    unsigned char address_buf[2]={0};
    address_buf[0] = (unsigned char)(address >> 8);
	address_buf[1] = (unsigned char)(address&0x00ff);
	EADRH = address_buf[0]; // read address
    EADRL = address_buf[1];
    asm ("MOVP"); // read data
    asm ("NOP");
    read_data = WORK;//store data in read_data
    return read_data;
}
