﻿/**********************************
* @file csu32m10_halt.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_HALT_H
#define  _CSU32M10_HALT_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER0_DIV128_VALUE_1S
* @brief define timer0 1s cnt
* Details.
*/
#define TIMER0_DIV128_VALUE_1S    249 


/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer0_set_wdtclk()  
* @brief set timer0 clk
* Details.
*/
#define timer0_set_wdtclk()       {TM0CON |= 0x02;}

/**
* @def wdt_clk_enable()  
* @brief enalbe wdt clk
* Details.
*/
#define wdt_clk_enable()          {CST_WDT = 0;}

/**
* @def timer0_clk_div_128() 
* @brief set timer0 clk div 128
* Details.
*/
#define timer0_clk_div_128()      {T0RATE_0 = 1;T0RATE_1 = 1;T0RATE_2 = 1;}

/**
* @def timer0_div_128_1s()  
* @brief set timer0 1s cnt
* Details.
*/
#define timer0_div_128_1s()       {TM0IN = TIMER0_DIV128_VALUE_1S;}

/**
* @def timer0_int_flag_clr()  
* @brief clr timer0 int flag
* Details.
*/
#define timer0_int_flag_clr()     {TM0IF = 0;}

/**
* @def timer0_int_enable() 
* @brief enable timer0 int flag
* Details.
*/
#define timer0_int_enable()       {TM0IE = 1;GIE = 1;}

/**
* @def timer0_count_clr() 
* @brief clr timer0 count
* Details.
*/
#define timer0_count_clr()        {T0RSTB = 0;}

/**
* @def timer0_count_start() 
* @brief timer0 count start
* Details.
*/
#define timer0_count_start()      {T0EN = 1;}



/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_halt_demo(void);


#endif