﻿/**********************************
* @file csu32m10_timer.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_TIMER_H
#define  _CSU32M10_TIMER_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER0_DIV128_VALUE_1S
* @brief define timer0 1s cnt
* Details.
*/
#define TIMER0_DIV128_VALUE_1S    249 

/**
* @defTIMER2_DIV128_VALUE_2MS
* @brief define timer2 1ms cnt
* Details.
*/
#define TIMER2_DIV128_VALUE_2MS   249 

/* Fuction Define -----------------------------------------------------------*/

/* Timer0 config -----------------------------------------------------------*/

/**
* @def timer0_set_wdtclk() 
* @brief set timer0 clk
* Details.
*/
#define timer0_set_wdtclk()       {TM0CON |= 0x02;}

/**
* @def wdt_clk_enable()  
* @brief enalbe wdt clk
* Details.
*/
#define wdt_clk_enable()          {CST_WDT = 0;}

/**
* @def timer0_clk_div_128() 
* @brief set timer0 clk div 128
* Details.
*/
#define timer0_clk_div_128()      {T0RATE_0 = 1;T0RATE_1 = 1;T0RATE_2 = 1;}

/**
* @def timer0_div_128_1s()  
* @brief set timer0 1s cnt
* Details.
*/
#define timer0_div_128_1s()       {TM0IN = TIMER0_DIV128_VALUE_1S;}

/**
* @def timer0_int_flag_clr()  
* @brief clr timer0 int flag
* Details.
*/
#define timer0_int_flag_clr()     {TM0IF = 0;}

/**
* @def timer0_int_enable() 
* @brief enable timer0 int flag
* Details.
*/
#define timer0_int_enable()       {TM0IE = 1;GIE = 1;}

/**
* @def timer0_count_clr() 
* @brief clr timer0 count
* Details.
*/
#define timer0_count_clr()        {T0RSTB = 0;}

/**
* @def timer0_count_start() 
* @brief timer0 count start
* Details.
*/
#define timer0_count_start()      {T0EN = 1;}

/* Timer2 config -----------------------------------------------------------*/

/**
* @def timer2_set_mck()  
* @brief set timer2 clk
* Details.
*/
#define timer2_set_mck()          {T2RATE_3 = 1;}

/**
* @def timer2_clk_div_128() 
* @brief set timer2 clk div 128
* Details.
*/
#define timer2_div_128()          {T2RATE_0 = 1;T2RATE_1 = 1;T2RATE_2 = 1;}

/**
* @def timer2_div_128_2ms()  
* @brief set timer2 2ms cnt
* Details.
*/
#define timer2_div_128_2ms()       {TM2IN = TIMER2_DIV128_VALUE_2MS;}

/**
* @def timer2_int_flag_clr()  
* @brief clr timer2 int flag
* Details.
*/
#define timer2_int_flag_clr()     {TM2IF = 0;}

/**
* @def timer2_count_start() 
* @brief start timer2 count
* Details.
*/
#define timer2_count_start()      {T2EN = 1;}

/**
* @def timer2_int_enable() 
* @brief enable timer2 int flag
* Details.
*/
#define timer2_int_enable()       {TM2IE = 1;GIE = 1;}

/**
* @def timer2_count_clr() 
* @brief clr timer2 count
* Details.
*/
#define timer2_count_clr()        {T2RSTB = 0;}



/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_timer0_init(void);
extern void csu32m10_timer2_init(void);


#endif