﻿/**********************************
* @file csu32m10_lcd.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_lcd.h"
#include "csu32m10_timer.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void csu32m10_gpio_init(void)
* @brief gpio initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_gpio_init(void);

/***********************************
* @fn  void csu32m10_lcd_init(void)
* @brief lcd initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_init(void);

/***********************************
* @fn  void csu32m10_lcd_com0_vdd_drive(void)
* @brief lcd com0 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com0_vdd_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com0_vss_drive(void)
* @brief lcd com0 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com0_vss_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com1_vdd_drive(void)
* @brief lcd com1 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com1_vdd_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com1_vss_drive(void)
* @brief lcd com1 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com1_vss_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com2_vdd_drive(void)
* @brief lcd com2 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com2_vdd_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com2_vss_drive(void)
* @brief lcd com2 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com2_vss_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com3_vdd_drive(void)
* @brief lcd com3 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com3_vdd_drive(void);

/***********************************
* @fn  void csu32m10_lcd_com3_vss_drive(void)
* @brief lcd com3 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_lcd_com3_vss_drive(void);

/***********************************
* @fn  void csu32m10_gpio_init(void)
* @brief gpio initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_gpio_init(void)
{
 /* com0 gpio init */
 
   PT1EN_4 = 1;
   PT1PU_4 = 0;
   PT1PD_4 = 0;
   
 /* com3 gpio init */  
 
   PT1EN_6 = 1;
   PT1PU_6 = 0;
   PT1PD_6 = 0;
   
  /* com2 gpio init */  
  
   PT5EN_0 = 1;
   PT5PU_0 = 0;
   PT5PD_0 = 0;
   
  /* com1 gpio init */  
  
   PT5EN_1 = 1;
   PT5PU_1 = 0;
   PT5PD_1 = 0;
   
   /* seg gpio init */
   
   PT3 = 0;
   PT3EN = 0x1f; //all seg set output mode
}

/***********************************
* @fn  void csu32m10_lcd_init(void)
* @brief lcd initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_init(void)
{
  csu32m10_gpio_init();
  csu32m10_timer0_init();
  csu32m10_timer2_init();  
}

/***********************************
* @fn  void csu32m10_lcd_com0_vdd_drive(void)
* @brief lcd com0 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com0_vdd_drive(void)
{
   	PT1EN_6 = 0; // set com3 io input mode
	PT1PU_6 = 1;
	PT1PD_6 = 1;
	LCDCOM = 0x0e; //set com1,com2,com3 output 1/2vdd
    LCD_COM0 = 1;    //set com0 output vdd
	PT1EN_4 = 1;
	PT1PU_4 = 0;
	PT1PD_4 = 0;  
}

/***********************************
* @fn  void csu32m10_lcd_com0_vss_drive(void)
* @brief lcd com0 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com0_vss_drive(void)
{
    LCD_COM0 = 0;    //set com0 output 0
}

/***********************************
* @fn  void csu32m10_lcd_com1_vdd_drive(void)
* @brief lcd com1 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com1_vdd_drive(void)
{
   	PT1EN_4 = 0; // set com0 io input mode
	PT1PU_4 = 1;
	PT1PD_4 = 1;
	LCDCOM = 0x0d; //set com0,com2,com3 output 1/2vdd
    LCD_COM1 = 1;    //set com1 output vdd
	PT5EN_1 = 1;
	PT5PU_1 = 0;
	PT5PD_1 = 0;  
}

/***********************************
* @fn  void csu32m10_lcd_com1_vss_drive(void)
* @brief lcd com1 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com1_vss_drive(void)
{
    LCD_COM1 = 0;    //set com1 output 0
}

/***********************************
* @fn  void csu32m10_lcd_com2_vdd_drive(void)
* @brief lcd com2 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com2_vdd_drive(void)
{
   	PT5EN_1 = 0; // set com1 io input mode
	PT5PU_1 = 1;
	PT5PD_1 = 1;
	LCDCOM = 0x0b; //set com0,com1,com3 output 1/2vdd
    LCD_COM2 = 1;    //set com2 output vdd
	PT5EN_0 = 1;
	PT5PU_0 = 0;
	PT5PD_0 = 0;  
}

/***********************************
* @fn  void csu32m10_lcd_com2_vss_drive(void)
* @brief lcd com2 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com2_vss_drive(void)
{
     LCD_COM2 = 0;    //set com2 output 0
}

/***********************************
* @fn  void csu32m10_lcd_com3_vdd_drive(void)
* @brief lcd com3 vdd drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com3_vdd_drive(void)
{
   	PT5EN_0 = 0; // set com2 io input mode
	PT5PU_0 = 1;
	PT5PD_0 = 1;
	LCDCOM = 0x07; //set com0,com1,com2 output 1/2vdd
    LCD_COM3 = 1;    //set com3 output vdd
	PT1EN_6 = 1;
	PT1PU_6 = 0;
	PT1PD_6 = 0;  
}

/***********************************
* @fn  void csu32m10_lcd_com3_vss_drive(void)
* @brief lcd com3 vss drive
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_lcd_com3_vss_drive(void)
{
    LCD_COM3 = 0;    //set com3 output 0
}

