﻿/**********************************
* @file csu32m10_timer3.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.03
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_timer3.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void csu32m10_timer3_pwm_init(void)
* @brief PWM output init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32M10_timer3_pwm_init(void);

/***********************************
* @fn  csu32m10_timer3_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/
void csu32M10_timer3_set_pwm_period(unsigned int period);

/***********************************
* @fn  csu32m10_timer3_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/
void csu32M10_timer3_set_pwm_duty(unsigned int duty);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  csu32m10_timer3_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/

void csu32m10_timer3_set_pwm_period(unsigned int period)
{
    unsigned int periodbuf[2]={0};
    periodbuf[0] = (unsigned int)(period >> 8);
	periodbuf[1] = (unsigned int)(period&0x00ff);
    TM3INH = periodbuf[0];
    TM3IN = periodbuf[1];
}

/***********************************
* @fn  csu32m10_timer3_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/

void csu32m10_timer3_set_pwm_duty(unsigned int duty)
{
    unsigned int dutybuf[2]={0};
    dutybuf[0] = (unsigned int)(duty >> 8);
	dutybuf[1] = (unsigned int)(duty&0x00ff);
    TM3RH = dutybuf[0];
    TM3R = dutybuf[1];
}

/***********************************
* @fn  void csu32m10_timer3_pwm_init(void)
* @brief PWM output init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_timer3_pwm_init(void)
{
  if(TIMER3_PWM_OUT_IO)
  {
    PT5EN_1 = 1; //set PT5.1 output mode
    PT5EN_0 = 1; //set PT5.0 output mode
    PWM3PO = 0; // set PT5.1 output pwm
    P3H_OEN = 1; // P5.1 output PWM3H
    P3L_OEN = 1; // P5.0 outout PWM3L
  }
  else
  {
    PT3EN_5 = 1; //set PT3.5 output mode
    PT1EN_0 = 1; //set PT1.0 output mode
    PWM3PO = 1; //set PT3.5 output pwm
    P3H2OEN = 1; // P1.0 output PWM3L
    P3L2OEN = 1; // P3.5 output PWM3H
  }
  timer3_set_pwm_mode(); //set timer3 pwm mode
  timer3_set_mck();// set mck as timer3 clk
  csu32m10_timer3_set_pwm_period(TIMER3_PWM_PERIOD); //set PWM period:200KHZ
  csu32m10_timer3_set_pwm_duty(TIMER3_PWM_DUTY_20); // set PWM duty:20%
  timer3_set_dt3ck(); //set DT3 clk
  if(TIMER3_PWM_SELECT_DT3) // set dead time 250ns
  {
    DT3CNT_2 = 1;
    DT3CNT_1 = 0;
    DT3CNT_0 = 0;
  }
  else // set dead time 0
  {
    DT3CNT_2 = 0;
    DT3CNT_1 = 0;
    DT3CNT_0 = 0;
  }
  timer3_dt3_enable();
  timer3_pwm_enable(); 
  timer3_count_clr(); // reset timer3 count
  timer3_pwm_start(); // start pwm
  timer3_int_enable();// enable timer3 int
}


