﻿/**********************************
* @file main.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_timer3.h"

/* Fuction Declare ----------------------------------------------------------*/
unsigned int pwm_temp = TIMER3_PWM_DUTY_20;
unsigned char time_5us_flag = 0;
/* Fuction Define -----------------------------------------------------------*/


/***********************************
* @fn   INT_FUNCTION(void) interrupt
* @brief interrupt service funcion.
* @param[out] 
* @param[in] 
* @return 
************************************/

void INT_FUNCTION(void) interrupt
{
   if(TM3IF)
   {
     TM3IF = 0;
     time_5us_flag = 1;  
   }
}

/***********************************
* @fn  main()
* @brief main function
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void main()
{
  csu32m10_timer3_pwm_init();
  while(1)
  {
     if(time_5us_flag)
     {
        time_5us_flag = 0;
        if(pwm_temp <= TIMER3_PWM_DUTY_80)
        {
           pwm_temp++;
        }
        else
        {
           pwm_temp = TIMER3_PWM_DUTY_20;
        }   
     }
     csu32m10_timer3_set_pwm_duty(pwm_temp);
  }
}
