﻿/**********************************
* @file csu32m10_wdt.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32M10_wdt.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  csu32m10_clr_wdt(void)
* @brief clear wdt count.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_clr_wdt(void);

/***********************************
* @fn  csu32m10_wdt_init(void)
* @brief wdt initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_wdt_init(void);

/***********************************
* @fn  csu32m10_clr_wdt(void)
* @brief clear wdt count.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_clr_wdt(void)
{
    asm("CLRWDT"); // clr wdt cnt
    asm("NOP");
    asm("NOP");
    asm("NOP");
}

/***********************************
* @fn  csu32m10_wdt_init(void)
* @brief wdt initialization
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_wdt_init(void)
{
   wdt_div_2();
   wdt_set_count(); // 16ms count
   wdt_clk_enable(); //32K osc on
   wdt_enable();
}

