﻿;============================================
; filename: csu32p20_adc.asm
; chip    : CSU32P20
; author  :
; date    : 2019-02-26
;============================================
include "CSU32P20.inc"

value_vref_vdd_h  equ  0x80
value_vref_vdd_l  equ  0x81

value_ain0_vdd_h  equ  0x82
value_ain0_vdd_l  equ  0x83

value_ain1_vref_h  equ  0x84
value_ain1_vref_l  equ  0x85

value_ain2_pt30_h  equ  0x86
value_ain2_pt30_l  equ  0x87

count_temp  equ  0x88
;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
delay_40uS:                   ;160 instructions   160*250nS=40uS
	nop
 	movlw 38
	movwf count_temp
loop_delay:
	nop
	decfsz count_temp,1
	goto  loop_delay	
	return
;============================================
; main program 
;============================================ 
Prog_Start:  
	bcf PT3EN,PT3EN_0           ;PT3.0 IN
	bcf PT3EN,PT3EN_1           ;PT3.1 IN
	movlw 0x12
	movwf SRADCON0              ;sampling time = 1/(4000000/4)*(12+0+8) = 20uS
loop_main:
test_vref_vdd:
	clrf PT3CON
	movlw 0x8f
	andwf METCH,1               ;1.4V
	movlw 0x60
	movwf SRADCON2              ;AIN8
	movlw 0x80
	movwf SRADCON1              ;enable ADC,vref=VDD
	call  delay_40uS            ;switch vref
	clrf  value_vref_vdd_h
	clrf  value_vref_vdd_l
	movlw 8
	movwf count_temp
loop_vref_vdd:
	bsf   SRADCON1,SRADS        ;start sample
	btfsc SRADCON1,SRADS        ;waiting
	goto  $-1
	movfw SRADL
	addwf value_vref_vdd_l,1
	movfw SRADH
	addwfc value_vref_vdd_h,1
	decfsz count_temp,1         ;8 times sampling
	goto   loop_vref_vdd

	movlw 3
	movwf count_temp	
average_vref_vdd:
	bcf STATUS,C
	RRF value_vref_vdd_h,1
	RRF value_vref_vdd_l,1
	decfsz count_temp,1         ;average value
	goto  average_vref_vdd

test_ain0_vdd:
	movlw 0x01
	movwf PT3CON                ;PT3.0
	clrf SRADCON2               ;AIN0
	movlw 0x80
	movwf SRADCON1              ;enable ADC,vref=VDD
	;call  delay_40uS           ;do not switch vref,no need delay
	clrf  value_ain0_vdd_h
	clrf  value_ain0_vdd_l
	movlw 8
	movwf count_temp
loop_ain0_vdd:
	bsf   SRADCON1,SRADS        ;start sample
	btfsc SRADCON1,SRADS        ;waiting
	goto  $-1
	movfw SRADL
	addwf value_ain0_vdd_l,1
	movfw SRADH
	addwfc value_ain0_vdd_h,1
	decfsz count_temp,1         ;8 times sampling
	goto   loop_ain0_vdd

	movlw 3
	movwf count_temp	
average_ain0_vdd:
	bcf STATUS,C
	RRF value_ain0_vdd_h,1
	RRF value_ain0_vdd_l,1
	decfsz count_temp,1         ;average value
	goto  average_ain0_vdd
	
test_ain1_vref:
	movlw 0x02
	movwf PT3CON                ;PT3.1
	movlw 0x8f
	andwf METCH,1               ;1.4V
	movlw 0x10
	movwf SRADCON2              ;AIN1
	movlw 0x82
	movwf SRADCON1              ;enable ADC,vref=vref
	call  delay_40uS            ;switch vref
	clrf  value_ain1_vref_h
	clrf  value_ain1_vref_l
	movlw 8
	movwf count_temp
loop_ain1_vref:
	bsf   SRADCON1,SRADS        ;start sample
	btfsc SRADCON1,SRADS        ;waiting
	goto  $-1
	movfw SRADL
	addwf value_ain1_vref_l,1
	movfw SRADH
	addwfc value_ain1_vref_h,1
	decfsz count_temp,1         ;8 times sampling
	goto   loop_ain1_vref

	movlw 3
	movwf count_temp	
average_ain1_vref:
	bcf STATUS,C
	RRF value_ain1_vref_h,1
	RRF value_ain1_vref_l,1
	decfsz count_temp,1         ;average value
	goto average_ain1_vref
	
test_ain2_pt30:
	movlw 0x04
	movwf PT3CON                ;PT3.2
	movlw 0x20
	movwf SRADCON2              ;AIN2
	movlw 0x81
	movwf SRADCON1              ;enable ADC,vref=V_pt3.0
	call  delay_40uS            ;switch vref
	clrf  value_ain2_pt30_h
	clrf  value_ain2_pt30_l
	movlw 8
	movwf count_temp
loop_ain2_pt30:
	bsf   SRADCON1,SRADS        ;start sample
	btfsc SRADCON1,SRADS        ;waiting
	goto  $-1
	movfw SRADL
	addwf value_ain2_pt30_l,1
	movfw SRADH
	addwfc value_ain2_pt30_h,1
	decfsz count_temp,1         ;8 times sampling
	goto   loop_ain2_pt30

	movlw 3
	movwf count_temp	
average_ain2_pt30:
	bcf STATUS,C
	RRF value_ain2_pt30_h,1
	RRF value_ain2_pt30_l,1
	decfsz count_temp,1         ;average value
	goto average_ain2_pt30
	
	goto loop_main
.end