;==============================================
; CSU32P20 Special Register Address Definition
; Date:2018-11-01
; Version: V1.0.0 
;==============================================

;Data Memory Organization 00h-08h
IND0              EQU              00H     ;{ IND0 }
FSR0              EQU              02H     ;{ FSR0 }
STATUS            EQU              04H     ;{ 0, LVD24, 0, PD, TO, DC, C, Z }
WORK              EQU              05H     ;{ WORK }
INTF              EQU              06H     ;{ 0, TM2IF, 0, TM0IF, SRADIF, 0, E1IF, E0IF }
INTE              EQU              07H     ;{ GIE, TM2IE, 0, TM0IE, SRADIE, 0, E1IE, E0IE }

;Peripheral special registers 09h-79h
RSTSR             EQU              09H     ;{ 0, 0, 0, 0, 0, EMCF, ILOPF, WWDTF }
EADRH             EQU              0AH     ;{ PAR[15:8] }
EADRL             EQU              0BH     ;{ PAR[7:0] }
EDATH             EQU              0CH     ;{ EDATH[7:0] }
WDTCON            EQU              0DH     ;{ WDTEN, 0, 0, 0, 0, WTS[2:0] }
WDTIN             EQU              0EH     ;{ WDTIN[7:0] }
TM0CON            EQU              0FH     ;{ T0EN, T0RATE[2:0], 0, T0RSTB, T0SEL[1:0] }
TM0IN             EQU              10H     ;{ TM0IN[7:0] }
TM0CNT            EQU              11H     ;{ TM0CNT[7:0] }
PAGECTL           EQU              14H     ;{ 0, 0, 0, 0, 0, 0, 0, PAGE2 }
MCK               EQU              16H     ;{ 0, 0, CST_WDT, 0, 0, 0, 0, 0 }
TM2CON            EQU              17H     ;{ T2EN, T2RATE[2:0], T2CKS, T2RSTB, T2OUT, PWM2OUT }
TM2IN             EQU              18H     ;{ TM2IN[7:0] }
TM2CNT            EQU              19H     ;{ TM2CNT[7:0] }
TM2R              EQU              1AH     ;{ TM2R[7:0] }
TM3CON            EQU              1BH     ;{ T3EN, T3RATE[2:0], T3CKS, T3RSTB, T3OUT, PWM3OUT }
TM3IN             EQU              1CH     ;{ TM3IN[7:0] }
TM3CNT            EQU              1DH     ;{ TM3CNT[7:0] }
TM3R              EQU              1EH     ;{ TM3R[7:0] }
TM3INH            EQU              1FH     ;{ 0, 0, 0, 0, TM3INH[11:8] }
PT1               EQU              20H     ;{ 0, PT1[6:3], 0, PT1[1:0] }
PT1EN             EQU              21H     ;{ 0, PT1EN[6:3], 0, PT1EN[1:0] }
PT1PU             EQU              22H     ;{ 0, PT1PU[6:3], 0, PT1PU[1:0] }
PT1CON            EQU              23H     ;{ PT11OD, PT1W[3:0], E1M, E0M[1:0] }
TM2INH            EQU              24H     ;{ 0, 0, 0, 0, TM2IN[11:8] }
TM2CNTH           EQU              25H     ;{ 0, 0, 0, 0, TM2CNT[11:8] }
TM2RH             EQU              26H     ;{ 0, 0, 0, 0, TM2R[11:8] }
TM3CNTH           EQU              27H     ;{ 0, 0, 0, 0, TM3CNT[11:8] }
PT3               EQU              28H     ;{ 0, 0, PT3[5:0] }
PT3EN             EQU              29H     ;{ 0, 0, PT3EN[5:0] }
PT3PU             EQU              2AH     ;{ 0, 0, PT3PU[5:0] }
PT3CON            EQU              2BH     ;{ 0, 0, PT3CON[5:0] }
TM3RH             EQU              2CH     ;{ 0, 0, 0, 0, TM3R[11:8] }
TM3CON2           EQU              2DH     ;{ DT3CK[1:0], DT3CNT[2:0], DT3_EN, P3H_OEN, P3L_OEN }
METCH1            EQU              2EH     ;{ P3HINV, P3LINV, PT1W[6:4], PWM2PO, 0, 0 }
METCH             EQU              2FH     ;{ VTHSEL, REF_SEL[2:0], PWMIS, T3RATE[3], T2RATE[3], P14_CUR }
PT5               EQU              30H     ;{ 0, 0, 0, 0, 0, 0, PT5[1:0] }
PT5EN             EQU              31H     ;{ 0, 0, 0, 0, 0, 0, PT5EN[1:0] }
PT5PU             EQU              32H     ;{ 0, 0, 0, 0, 0, 0, PT5PU[1:0] }
PT5CON            EQU              33H     ;{ 0, 0, 0, 0, 0, 0, PT51OD, PT50OD }
SRADCON0          EQU              34H     ;{ 0, 0, SRADACKS[1:0], 0, 0, SRADCKS[1:0] }
SRADCON1          EQU              35H     ;{ SRADEN, SRADS, OFTEN, CALIF, ENOV, OFFEX, VREFS[1:0] }
SRADCON2          EQU              36H     ;{ CHS[3:0], 0, 0, 0, 0 }
SRADL             EQU              37H     ;{ SRAD[7:0] }
SRADH             EQU              38H     ;{ 0, 0, 0, 0, SRAD[11:8] }
SROFTL            EQU              39H     ;{ SROFT[7:0] }
SROFTH            EQU              3AH     ;{ 0, 0, 0, 0, SROFT[11:8] }
INTF2             EQU              3CH     ;{ 0, 0, 0, TM3IF, 0, 0, 0, 0 }
INTE2             EQU              3DH     ;{ 0, 0, 0, TM3IE, 0, 0, 0, 0 }
INTCFG            EQU              40H     ;{ INTCFG _LVD36, INTCFG _LVD24, 0, 0, 0, INTCFG[2:0] }
PT1CON1           EQU              41H     ;{ 0, 0, 0, 0, 0, 0, 0, PT1CON0 }
PT1PD             EQU              42H     ;{ 0, PT1PD[6:3], 0, PT1PD[1:0] }
PT3PD             EQU              43H     ;{ 0, 0, PT3PD[5:0] }
PT5PD             EQU              44H     ;{ 0, 0, 0, 0, 0, 0, PT5PD[1:0] }
TM3CON3           EQU              45H     ;{ PWM3PO, 0, 0, 0, P3H2INV, P3L2INV, P3H2OEN, P3L2OEN }
LCDCOM            EQU              46H     ;{ 0, 0, 0, LCDCOM[4:0] }
WWDTCR            EQU              47H     ;{ WWDTEN, TR[6:0] }
WWDTWR            EQU              48H     ;{ 0, WD[6:0] }
METCH2            EQU              79H     ;{ 0, 0, 0, 0, METCH[3:0] }

;-------------------------------------------------------
;  STATUS register bit map
;-------------------------------------------------------
Z                 EQU              0
C                 EQU              1
DC                EQU              2
TO                EQU              3
PD                EQU              4
LVD24             EQU              6

;-------------------------------------------------------
;  INTF register bit map
;-------------------------------------------------------
E0IF              EQU              0
E1IF              EQU              1
SRADIF            EQU              3
TM0IF             EQU              4
TM2IF             EQU              6

;-------------------------------------------------------
;  INTE register bit map
;-------------------------------------------------------
E0IE              EQU              0
E1IE              EQU              1
SRADIE            EQU              3
TM0IE             EQU              4
TM2IE             EQU              6
GIE               EQU              7

;-------------------------------------------------------
;  RSTSR register bit map
;-------------------------------------------------------
WWDTF             EQU              0
ILOPF             EQU              1
EMCF              EQU              2

;-------------------------------------------------------
;  EADRH register bit map
;-------------------------------------------------------
PAR_8             EQU              0
PAR_9             EQU              1
PAR_10            EQU              2
PAR_11            EQU              3
PAR_12            EQU              4
PAR_13            EQU              5
PAR_14            EQU              6
PAR_15            EQU              7

;-------------------------------------------------------
;  EADRL register bit map
;-------------------------------------------------------
PAR_0             EQU              0
PAR_1             EQU              1
PAR_2             EQU              2
PAR_3             EQU              3
PAR_4             EQU              4
PAR_5             EQU              5
PAR_6             EQU              6
PAR_7             EQU              7

;-------------------------------------------------------
;  EDATH register bit map
;-------------------------------------------------------
EDATH_0           EQU              0
EDATH_1           EQU              1
EDATH_2           EQU              2
EDATH_3           EQU              3
EDATH_4           EQU              4
EDATH_5           EQU              5
EDATH_6           EQU              6
EDATH_7           EQU              7

;-------------------------------------------------------
;  WDTCON register bit map
;-------------------------------------------------------
WTS_0             EQU              0
WTS_1             EQU              1
WTS_2             EQU              2
WDTEN             EQU              7

;-------------------------------------------------------
;  WDTIN register bit map
;-------------------------------------------------------
WDTIN_0           EQU              0
WDTIN_1           EQU              1
WDTIN_2           EQU              2
WDTIN_3           EQU              3
WDTIN_4           EQU              4
WDTIN_5           EQU              5
WDTIN_6           EQU              6
WDTIN_7           EQU              7

;-------------------------------------------------------
;  TM0CON register bit map
;-------------------------------------------------------
T0SEL_0           EQU              0
T0SEL_1           EQU              1
T0RSTB            EQU              2
T0RATE_0          EQU              4
T0RATE_1          EQU              5
T0RATE_2          EQU              6
T0EN              EQU              7

;-------------------------------------------------------
;  TM0IN register bit map
;-------------------------------------------------------
TM0IN_0           EQU              0
TM0IN_1           EQU              1
TM0IN_2           EQU              2
TM0IN_3           EQU              3
TM0IN_4           EQU              4
TM0IN_5           EQU              5
TM0IN_6           EQU              6
TM0IN_7           EQU              7

;-------------------------------------------------------
;  TM0CNT register bit map
;-------------------------------------------------------
TM0CNT_0          EQU              0
TM0CNT_1          EQU              1
TM0CNT_2          EQU              2
TM0CNT_3          EQU              3
TM0CNT_4          EQU              4
TM0CNT_5          EQU              5
TM0CNT_6          EQU              6
TM0CNT_7          EQU              7

;-------------------------------------------------------
;  PAGECTL register bit map
;-------------------------------------------------------
PAGE2             EQU              0

;-------------------------------------------------------
;  MCK register bit map
;-------------------------------------------------------
CST_WDT           EQU              5

;-------------------------------------------------------
;  TM2CON register bit map
;-------------------------------------------------------
PWM2OUT           EQU              0
T2OUT             EQU              1
T2RSTB            EQU              2
T2CKS             EQU              3
T2RATE_0          EQU              4
T2RATE_1          EQU              5
T2RATE_2          EQU              6
T2EN              EQU              7

;-------------------------------------------------------
;  TM2IN register bit map
;-------------------------------------------------------
TM2IN_0           EQU              0
TM2IN_1           EQU              1
TM2IN_2           EQU              2
TM2IN_3           EQU              3
TM2IN_4           EQU              4
TM2IN_5           EQU              5
TM2IN_6           EQU              6
TM2IN_7           EQU              7

;-------------------------------------------------------
;  TM2CNT register bit map
;-------------------------------------------------------
TM2CNT_0          EQU              0
TM2CNT_1          EQU              1
TM2CNT_2          EQU              2
TM2CNT_3          EQU              3
TM2CNT_4          EQU              4
TM2CNT_5          EQU              5
TM2CNT_6          EQU              6
TM2CNT_7          EQU              7

;-------------------------------------------------------
;  TM2R register bit map
;-------------------------------------------------------
TM2R_0            EQU              0
TM2R_1            EQU              1
TM2R_2            EQU              2
TM2R_3            EQU              3
TM2R_4            EQU              4
TM2R_5            EQU              5
TM2R_6            EQU              6
TM2R_7            EQU              7

;-------------------------------------------------------
;  TM3CON register bit map
;-------------------------------------------------------
PWM3OUT           EQU              0
T3OUT             EQU              1
T3RSTB            EQU              2
T3CKS             EQU              3
T3RATE_0          EQU              4
T3RATE_1          EQU              5
T3RATE_2          EQU              6
T3EN              EQU              7

;-------------------------------------------------------
;  TM3IN register bit map
;-------------------------------------------------------
TM3IN_0           EQU              0
TM3IN_1           EQU              1
TM3IN_2           EQU              2
TM3IN_3           EQU              3
TM3IN_4           EQU              4
TM3IN_5           EQU              5
TM3IN_6           EQU              6
TM3IN_7           EQU              7

;-------------------------------------------------------
;  TM3CNT register bit map
;-------------------------------------------------------
TM3CNT_0          EQU              0
TM3CNT_1          EQU              1
TM3CNT_2          EQU              2
TM3CNT_3          EQU              3
TM3CNT_4          EQU              4
TM3CNT_5          EQU              5
TM3CNT_6          EQU              6
TM3CNT_7          EQU              7

;-------------------------------------------------------
;  TM3R register bit map
;-------------------------------------------------------
TM3R_0            EQU              0
TM3R_1            EQU              1
TM3R_2            EQU              2
TM3R_3            EQU              3
TM3R_4            EQU              4
TM3R_5            EQU              5
TM3R_6            EQU              6
TM3R_7            EQU              7

;-------------------------------------------------------
;  TM3INH register bit map
;-------------------------------------------------------
TM3INH_8          EQU              0
TM3INH_9          EQU              1
TM3INH_10         EQU              2
TM3INH_11         EQU              3

;-------------------------------------------------------
;  PT1 register bit map
;-------------------------------------------------------
PT1_0             EQU              0
PT1_1             EQU              1
PT1_3             EQU              3
PT1_4             EQU              4
PT1_5             EQU              5
PT1_6             EQU              6

;-------------------------------------------------------
;  PT1EN register bit map
;-------------------------------------------------------
PT1EN_0           EQU              0
PT1EN_1           EQU              1
PT1EN_3           EQU              3
PT1EN_4           EQU              4
PT1EN_5           EQU              5
PT1EN_6           EQU              6

;-------------------------------------------------------
;  PT1PU register bit map
;-------------------------------------------------------
PT1PU_0           EQU              0
PT1PU_1           EQU              1
PT1PU_3           EQU              3
PT1PU_4           EQU              4
PT1PU_5           EQU              5
PT1PU_6           EQU              6

;-------------------------------------------------------
;  PT1CON register bit map
;-------------------------------------------------------
E0M_0             EQU              0
E0M_1             EQU              1
E1M               EQU              2
PT1W_0            EQU              3
PT1W_1            EQU              4
PT1W_2            EQU              5
PT1W_3            EQU              6
PT11OD            EQU              7

;-------------------------------------------------------
;  TM2INH register bit map
;-------------------------------------------------------
TM2IN_8           EQU              0
TM2IN_9           EQU              1
TM2IN_10          EQU              2
TM2IN_11          EQU              3

;-------------------------------------------------------
;  TM2CNTH register bit map
;-------------------------------------------------------
TM2CNT_8          EQU              0
TM2CNT_9          EQU              1
TM2CNT_10         EQU              2
TM2CNT_11         EQU              3

;-------------------------------------------------------
;  TM2RH register bit map
;-------------------------------------------------------
TM2R_8            EQU              0
TM2R_9            EQU              1
TM2R_10           EQU              2
TM2R_11           EQU              3

;-------------------------------------------------------
;  TM3CNTH register bit map
;-------------------------------------------------------
TM3CNT_8          EQU              0
TM3CNT_9          EQU              1
TM3CNT_10         EQU              2
TM3CNT_11         EQU              3

;-------------------------------------------------------
;  PT3 register bit map
;-------------------------------------------------------
PT3_0             EQU              0
PT3_1             EQU              1
PT3_2             EQU              2
PT3_3             EQU              3
PT3_4             EQU              4
PT3_5             EQU              5

;-------------------------------------------------------
;  PT3EN register bit map
;-------------------------------------------------------
PT3EN_0           EQU              0
PT3EN_1           EQU              1
PT3EN_2           EQU              2
PT3EN_3           EQU              3
PT3EN_4           EQU              4
PT3EN_5           EQU              5

;-------------------------------------------------------
;  PT3PU register bit map
;-------------------------------------------------------
PT3PU_0           EQU              0
PT3PU_1           EQU              1
PT3PU_2           EQU              2
PT3PU_3           EQU              3
PT3PU_4           EQU              4
PT3PU_5           EQU              5

;-------------------------------------------------------
;  PT3CON register bit map
;-------------------------------------------------------
PT3CON_0          EQU              0
PT3CON_1          EQU              1
PT3CON_2          EQU              2
PT3CON_3          EQU              3
PT3CON_4          EQU              4
PT3CON_5          EQU              5

;-------------------------------------------------------
;  TM3RH register bit map
;-------------------------------------------------------
TM3R_8            EQU              0
TM3R_9            EQU              1
TM3R_10           EQU              2
TM3R_11           EQU              3

;-------------------------------------------------------
;  TM3CON2 register bit map
;-------------------------------------------------------
P3L_OEN           EQU              0
P3H_OEN           EQU              1
DT3_EN            EQU              2
DT3CNT_0          EQU              3
DT3CNT_1          EQU              4
DT3CNT_2          EQU              5
DT3CK_0           EQU              6
DT3CK_1           EQU              7

;-------------------------------------------------------
;  METCH1 register bit map
;-------------------------------------------------------
PWM2PO            EQU              2
PT1W_4            EQU              3
PT1W_5            EQU              4
PT1W_6            EQU              5
P3LINV            EQU              6
P3HINV            EQU              7

;-------------------------------------------------------
;  METCH register bit map
;-------------------------------------------------------
P14_CUR           EQU              0
T2RATE_3          EQU              1
T3RATE_3          EQU              2
PWMIS             EQU              3
REF_SEL_0         EQU              4
REF_SEL_1         EQU              5
REF_SEL_2         EQU              6
VTHSEL            EQU              7

;-------------------------------------------------------
;  PT5 register bit map
;-------------------------------------------------------
PT5_0             EQU              0
PT5_1             EQU              1

;-------------------------------------------------------
;  PT5EN register bit map
;-------------------------------------------------------
PT5EN_0           EQU              0
PT5EN_1           EQU              1

;-------------------------------------------------------
;  PT5PU register bit map
;-------------------------------------------------------
PT5PU_0           EQU              0
PT5PU_1           EQU              1

;-------------------------------------------------------
;  PT5CON register bit map
;-------------------------------------------------------
PT50OD            EQU              0
PT51OD            EQU              1

;-------------------------------------------------------
;  SRADCON0 register bit map
;-------------------------------------------------------
SRADCKS_0         EQU              0
SRADCKS_1         EQU              1
SRADACKS_0        EQU              4
SRADACKS_1        EQU              5

;-------------------------------------------------------
;  SRADCON1 register bit map
;-------------------------------------------------------
VREFS_0           EQU              0
VREFS_1           EQU              1
OFFEX             EQU              2
ENOV              EQU              3
CALIF             EQU              4
OFTEN             EQU              5
SRADS             EQU              6
SRADEN            EQU              7

;-------------------------------------------------------
;  SRADCON2 register bit map
;-------------------------------------------------------
CHS_0             EQU              4
CHS_1             EQU              5
CHS_2             EQU              6
CHS_3             EQU              7

;-------------------------------------------------------
;  SRADL register bit map
;-------------------------------------------------------
SRAD_0            EQU              0
SRAD_1            EQU              1
SRAD_2            EQU              2
SRAD_3            EQU              3
SRAD_4            EQU              4
SRAD_5            EQU              5
SRAD_6            EQU              6
SRAD_7            EQU              7

;-------------------------------------------------------
;  SRADH register bit map
;-------------------------------------------------------
SRAD_8            EQU              0
SRAD_9            EQU              1
SRAD_10           EQU              2
SRAD_11           EQU              3

;-------------------------------------------------------
;  SROFTL register bit map
;-------------------------------------------------------
SROFT_0           EQU              0
SROFT_1           EQU              1
SROFT_2           EQU              2
SROFT_3           EQU              3
SROFT_4           EQU              4
SROFT_5           EQU              5
SROFT_6           EQU              6
SROFT_7           EQU              7

;-------------------------------------------------------
;  SROFTH register bit map
;-------------------------------------------------------
SROFT_8           EQU              0
SROFT_9           EQU              1
SROFT_10          EQU              2
SROFT_11          EQU              3

;-------------------------------------------------------
;  INTF2 register bit map
;-------------------------------------------------------
TM3IF             EQU              4

;-------------------------------------------------------
;  INTE2 register bit map
;-------------------------------------------------------
TM3IE             EQU              4

;-------------------------------------------------------
;  INTCFG register bit map
;-------------------------------------------------------
INTCFG_0          EQU              0
INTCFG_1          EQU              1
INTCFG_2          EQU              2
INTCFG_LVD24        EQU              6
INTCFG_LVD36        EQU              7

;-------------------------------------------------------
;  PT1CON1 register bit map
;-------------------------------------------------------
PT1CON0           EQU              0

;-------------------------------------------------------
;  PT1PD register bit map
;-------------------------------------------------------
PT1PD_0           EQU              0
PT1PD_1           EQU              1
PT1PD_3           EQU              3
PT1PD_4           EQU              4
PT1PD_5           EQU              5
PT1PD_6           EQU              6

;-------------------------------------------------------
;  PT3PD register bit map
;-------------------------------------------------------
PT3PD_0           EQU              0
PT3PD_1           EQU              1
PT3PD_2           EQU              2
PT3PD_3           EQU              3
PT3PD_4           EQU              4
PT3PD_5           EQU              5

;-------------------------------------------------------
;  PT5PD register bit map
;-------------------------------------------------------
PT5PD_0           EQU              0
PT5PD_1           EQU              1

;-------------------------------------------------------
;  TM3CON3 register bit map
;-------------------------------------------------------
P3L2OEN           EQU              0
P3H2OEN           EQU              1
P3L2INV           EQU              2
P3H2INV           EQU              3
PWM3PO            EQU              7

;-------------------------------------------------------
;  LCDCOM register bit map
;-------------------------------------------------------
LCDCOM_0          EQU              0
LCDCOM_1          EQU              1
LCDCOM_2          EQU              2
LCDCOM_3          EQU              3
LCDCOM_4          EQU              4

;-------------------------------------------------------
;  WWDTCR register bit map
;-------------------------------------------------------
TR_0              EQU              0
TR_1              EQU              1
TR_2              EQU              2
TR_3              EQU              3
TR_4              EQU              4
TR_5              EQU              5
TR_6              EQU              6
WWDTEN            EQU              7

;-------------------------------------------------------
;  WWDTWR register bit map
;-------------------------------------------------------
WD_0              EQU              0
WD_1              EQU              1
WD_2              EQU              2
WD_3              EQU              3
WD_4              EQU              4
WD_5              EQU              5
WD_6              EQU              6

;-------------------------------------------------------
;  METCH2 register bit map
;-------------------------------------------------------
METCH_0           EQU              0
METCH_1           EQU              1
METCH_2           EQU              2
METCH_3           EQU              3

