﻿;============================================
; filename: csu32p20_timer0.asm
; chip    : CSU32P20
; author  :
; date    : 2019-02-13
;============================================
include "CSU32P20.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
	btfss INTF,TM0IF
	goto  end_int
	bcf   INTF,TM0IF
	btfss PT1,PT1_0
	goto  high_level
	goto  low_level
low_level:
	bcf   PT1,PT1_0
	goto  end_int
high_level:
	bsf   PT1,PT1_0
end_int:
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	movlw 0x01
	movwf PT1EN                 ;PT1_0:out
	
	movlw 0x70
	movwf TM0CON
	movlw 249
	movwf TM0IN                 ;(249+1)/(4MHz/128)=8mS
	bsf   TM0CON,T0EN           ;enable timer0
	bsf   INTE,TM0IE            ;enable timer0 interrupt
	bsf   INTE,GIE              ;enable interrupt
	
	goto $						; loop forever
.end

