﻿;============================================
; filename: csu32p20_timer2.asm
; chip    : CSU32P20
; author  :
; date    : 2019-02-14
;============================================
include "CSU32P20.inc"

DEFINE  PERIOD_PWM2         (2500-1)    ;50Hz
DEFINE  DUTY_CYCLE_20_PWM2  (500-1)     ;20%
DEFINE  DUTY_CYCLE_80_PWM2  (2000-1)    ;80%

DEFINE  IO_OUT    0         ;pt5.0: =1  pt3.1: =0

tm2rh_temp   equ 0x80
tm2r_temp    equ 0x81

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
	btfss INTF,TM2IF
	goto  end_int
	bcf   INTF,TM2IF            ;clear tm2if
	movlw  low DUTY_CYCLE_80_PWM2      ; 2000 80%
	subwf  tm2r_temp,0
	movlw  high DUTY_CYCLE_80_PWM2
	subwfc tm2rh_temp,0
	btfsc STATUS,C
	goto  int_tm2r
	goto  add_tm2r
int_tm2r:
	movlw  high DUTY_CYCLE_20_PWM2    ; 500 20%
	movwf  tm2rh_temp
	movlw  low DUTY_CYCLE_20_PWM2
	movwf  tm2r_temp
	goto   set_tm2r
add_tm2r:
	movlw 1
	addwf tm2r_temp,1
	movlw 0
	addwfc tm2rh_temp,1
set_tm2r:
	movfw  tm2rh_temp
	movwf  TM2RH 
	movfw  tm2r_temp
	movwf  TM2R
end_int:
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bsf    METCH,T2RATE_3       ; MCK
if  IO_OUT == 1
	bsf    PT5EN,PT5EN_0          ; PT5_0:out
//	bsf    PT3EN,PT3EN_1          ; PT3_1:out  
	bcf    METCH1,PWM2PO
else
//	bsf    PT5EN,PT5EN_0          ; PT5_0:out
	bsf    PT3EN,PT3EN_1          ; PT3_1:out
	bsf    METCH1,PWM2PO
endif
	movlw  0x71
	movwf  TM2CON
	movlw  high PERIOD_PWM2
	movwf  TM2INH 
	movlw  low PERIOD_PWM2
	movwf  TM2IN                ; (2499+1)/(16MHz/128)=20mS=50Hz
	
	movlw  high DUTY_CYCLE_20_PWM2
	movwf  TM2RH 
	movwf  tm2rh_temp
	movlw  low DUTY_CYCLE_20_PWM2
	movwf  TM2R                 ; 500 20%
	movwf  tm2r_temp
	
	bsf    TM2CON,T2EN
	bsf    INTE,TM2IE
	bsf    INTE,GIE
loop:	
	goto $						; loop forever
.end