﻿;============================================
; filename: csu32p20_wwdt.asm
; chip    : CSU32P20
; author  :
; date    : 2019-03-11
;============================================
include "CSU32P20.inc"

WWDTCR_BUF  equ  80H
;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	
	MOVLW	7FH
	MOVWF	WWDTCR			;设置复位时间
	MOVLW	5FH
	MOVWF   WWDTWR			;设置窗口时间
	BSF		WWDTCR, WWDTEN	;使能窗口看门狗
	BSF     PT1EN,PT1EN_0
	BSF     PT1,PT1_0
loop:	
	NOP
	NOP
	MOVFW  WWDTCR
	MOVWF  WWDTCR_BUF
	BCF	   WWDTCR_BUF,7
	MOVLW  5EH
	SUBWF  WWDTCR_BUF,1
	BTFSC  STATUS,C
	GOTO   loop
	MOVLW  7FH			
	MOVWF  WWDTCR			;重新赋值窗口看门狗
	goto   loop				
.end