﻿/**********************************
* @file csu32p20_lcd.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32P20_LCD_H
#define  _CSU32P20_LCD_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32P20.h"

/* Fuction Define -----------------------------------------------------------*/

/* Fuction Define -----------------------------------------------------------*/

/**
* @def LCD_COM0 PT1_4
* @brief define PT1_4 as LCD_COM0
* Details.
*/
#define LCD_COM0  PT1_4

/**
* @def LCD_COM1 PT5_1
* @brief define PT5_1 as LCD_COM1
* Details.
*/
#define LCD_COM1  PT5_1

/**
* @def LCD_COM2 PT5_0
* @brief define PT5_0 as LCD_COM2
* Details.
*/
#define LCD_COM2  PT5_0

/**
* @def LCD_COM3 PT1_6
* @brief define PT1_6 as LCD_COM3
* Details.
*/
#define LCD_COM3  PT1_6

/**
* @def LCD_SEG0 PT3_0
* @brief define PT3_0 as LCD_SEG0
* Details.
*/
#define LCD_SEG0  PT3_0

/**
* @def LCD_SEG1 PT3_1
* @brief define PT3_1 as LCD_SEG1
* Details.
*/
#define LCD_SEG1  PT3_1

/**
* @def LCD_SEG2 PT3_2
* @brief define PT3_2 as LCD_SEG2
* Details.
*/
#define LCD_SEG2  PT3_2

/**
* @def LCD_SEG0 PT3_3
* @brief define PT3_3 as LCD_SEG3
* Details.
*/
#define LCD_SEG3  PT3_3

/**
* @def LCD_SEG0 PT3_4
* @brief define PT3_4 as LCD_SEG4
* Details.
*/
#define LCD_SEG4  PT3_4

/**
* @enum disp_com_scan_t
* @brief The com sacn configuration
*/
typedef enum
{ 
  COM0_VDD_SCAN = 0,
  COM0_VSS_SCAN,
  COM1_VDD_SCAN,
  COM1_VSS_SCAN,
  COM2_VDD_SCAN,
  COM2_VSS_SCAN,
  COM3_VDD_SCAN,
  COM3_VSS_SCAN
}disp_com_scan_t;

/**
* @struct disp_base_t
* @brief The display base configuration
*/
typedef  struct
{
  unsigned char unit;
  unsigned char tens;
  unsigned char hundreds;
  unsigned char unit_temp;
  unsigned char tens_temp;
  unsigned char hundreds_temp;
  unsigned char unit_display;
  unsigned char tens_display;
  unsigned char hundreds_display;  
  unsigned char num;
  disp_com_scan_t  com_scan;
}disp_base_t;

/* Exported functions 
--------------------------------------------------------*/

extern void csu32p20_lcd_init(void);
extern void csu32p20_lcd_com0_vdd_drive(void);
extern void csu32p20_lcd_com0_vss_drive(void);
extern void csu32p20_lcd_com1_vdd_drive(void);
extern void csu32p20_lcd_com1_vss_drive(void);
extern void csu32p20_lcd_com2_vdd_drive(void);
extern void csu32p20_lcd_com2_vss_drive(void);
extern void csu32p20_lcd_com3_vdd_drive(void);
extern void csu32p20_lcd_com3_vss_drive(void);
extern disp_base_t display_base;

#endif