﻿/**********************************
* @file csu32p20_sleep.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.03
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32P20.h"
#include "csu32p20_sleep.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
static void delay_us(void);

/***********************************
* @fn  void csu32p20_enter_sleep(void)
* @brief csu32p20 enter sleep mode.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32p20_enter_sleep(void);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

static void delay_us(void)
{
  unsigned char j;
  for(j = 200;j > 0;j--);
}

/***********************************
* @fn  void csu32p20_enter_sleep(void)
* @brief csu32p20 enter sleep mode.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32p20_enter_sleep(void)
{
   //PT1 io config
   PT1 = 0;
   PT1EN = 0xF7; // set PT1.3 input mode
   PT1PU = 0x08; // PT1.3 pull up
   PT1CON = 0x14; //enable PT1.3 INT1 
   PT1PD = 0;
   
   //PT3 io config
   PT3 = 0;
   PT3EN = 0x3F;
   PT3PU = 0; 
   PT3CON = 0; 
   PT3PD = 0;
   
   //PT5 io config
   PT5 = 0;
   PT5EN = 0x03;
   PT5PU = 0; 
   PT5CON = 0; 
   PT5PD = 0;
   
   CST_WDT = 1; // disable wdt clk
   TM0CON = 0; // disable timer0
   TM2CON = 0; // disable timer2
   TM3CON = 0; // disable timer3
   SRADCON1 = 0;// disable ADC
   
wakeup_check:
   while(!PT1_3);
   E1IF = 0;  //clr int1 flag
   E1IE = 1;  // enable int1
   GIE = 1;
   asm("sleep"); // enter sleep mode
  
   delay_us();
   E1IE = 0;
   goto wakeup_check;   
}

