﻿/**********************************
* @file main.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32P20.h"
#include "csu32p20_timer2.h"

/* Fuction Declare ----------------------------------------------------------*/
unsigned int pwm_temp = TIMER2_PWM_DUTY_20;

/* Fuction Define -----------------------------------------------------------*/


/***********************************
* @fn   INT_FUNCTION(void) interrupt
* @brief interrupt service funcion.
* @param[out] 
* @param[in] 
* @return 
************************************/

void INT_FUNCTION(void) interrupt
{
   if(TM2IF)
   {
     TM2IF = 0;
     if(pwm_temp <= TIMER2_PWM_DUTY_80)
     {
        pwm_temp++;
     }
     else
     {
        pwm_temp = TIMER2_PWM_DUTY_20;
     }
   }
}

/***********************************
* @fn  main()
* @brief main function
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void main()
{
  csu32p20_timer2_pwm_init();
  while(1)
  {
     csu32p20_timer2_set_pwm_duty(pwm_temp);
  }
}
