﻿/**********************************
* @file csu32p20_timer2.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32P20_TIMER3_H
#define  _CSU32P20_TIMER3_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32P20.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER3_PWM_PERIOD
* @brief define pwm period
* Details.
*/
#define TIMER3_PWM_PERIOD        (80-1)  //200KHZ 

/**
* @def TIMER3_PWM_DUTY_20
* @brief define pwm 20% duty
* Details.
*/
#define TIMER3_PWM_DUTY_20       (16-1)   //20%

/**
* @def TIMER3_PWM_DUTY_80
* @brief define pwm 80% duty
* Details.
*/
#define TIMER3_PWM_DUTY_80       (64-1)  //80% 

/**
* @def TIMER3_PWM_OUT_IO
* @brief output io select
* Details.
*/
#define TIMER3_PWM_OUT_IO             1  //1:PT5.0/PT5.1 output 0:PT3.5/PT1.0 output    

/**
* @def TIMER3_PWM_SELECT_DT3
* @brief dead time select
* Details.
*/
#define TIMER3_PWM_SELECT_DT3         1  //1:select dead time set 250ns, 0:select dead time set 0       

/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer3_set_pwm_mode()
* @brief set timer3 as pwm mode
* Details.
*/
#define timer3_set_pwm_mode()     {T3OUT = 0;PWM3OUT = 1;}

/**
* @def timer3_set_mck()
* @brief set timer2 clk
* Details.
*/
#define timer3_set_mck()          {T3RATE_3 = 0;T3RATE_2 = 0;T3RATE_1 = 0;T3RATE_0 = 0;}

/**
* @def timer3_pwm_enable()
* @brief enable pwm output
* Details.
*/
#define timer3_pwm_enable()       {PWM3OUT = 1;}

/**
* @def timer3_pwm_start() 
* @brief pwm cnt start
* Details.
*/
#define timer3_pwm_start()        {T3EN = 1;}

/**
* @def timer3_int_enable()  
* @brief enable timer3 int 
* Details.
*/
#define timer3_int_enable()       {TM3IE = 1;GIE = 1;}

/**
* @def timer3_count_clr()  
* @brief timer3 count clr
* Details.
*/
#define timer3_count_clr()        {T3RSTB = 0;}

/**
* @def timer3_set_dt3ck()  
* @brief set DT3 clk
* Details.
*/
#define timer3_set_dt3ck()        {DT3CK_0 = 0;DT3CK_1 = 0;}
                                
/**
* @def timer3_dt3_enable() 
* @brief dead time output enable
* Details.
*/
#define timer3_dt3_enable()       {DT3_EN = 1;}


/* Exported functions 
--------------------------------------------------------*/

extern void csu32p20_timer3_pwm_init(void);
extern void csu32p20_timer3_set_pwm_period(unsigned int period);
extern void csu32p20_timer3_set_pwm_duty(unsigned int duty);


#endif